// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "TopWidget.h"

#include <qkeycode.h>
#include <qrect.h>

#include <kapp.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kconfig.h>
#include <kaction.h>
#include <kstdaction.h>

#include "MainWindow.h"

#include "TopWidget.moc"

TopWidget::TopWidget(const char *name):
  KMainWindow(0,name) {
  QRect DefaultRect(100,20,500,430);
  KConfig *config;
  MainWindow *mainw;


  config=kapp->config();

  //  setCaption(kapp->makeStdCaption(i18n("Project Window")));
  setCaption(i18n("Project Window"));
  //  KStdAction::open(mainw,SLOT(openProject()),actionCollection());
  //  createGUI("kreatecdui.rc");

  mainw=new MainWindow(this);
  setCentralWidget(mainw);

  //JW: Will be moved to TrackListManager
  KStdAction::open(mainw,SLOT(openProject()),actionCollection());
  KStdAction::openNew(mainw,SLOT(newProject()),actionCollection());
  KStdAction::save(mainw,SLOT(saveProject()),actionCollection());
  KStdAction::saveAs(mainw,SLOT(saveProjectAs()),actionCollection());


  KStdAction::quit(this,SLOT(leaveMe()),actionCollection());
  // JW: Will be moved to TopLevel
  KStdAction::preferences(mainw,SLOT(configDialog()),actionCollection());
  
  // JW: Will be moved to a class, which purpose is to handle tools and plugins
  
  (void) new KAction(i18n("&Copy CDROM..."),0,mainw,SLOT(setupCopy()),actionCollection(),"copy_CD");

  //AUDIO STUFF
  (void) new KAction(i18n("Normalize to maximum"),0,mainw,SLOT(normalizeMax()),actionCollection(),"audio_norm_max");
  (void) new KAction(i18n("Normalize all to same"),0,mainw,SLOT(normalizeAllSame()),actionCollection(),"audio_norm_same");

  //BLANK STUFF
  (void) new KAction(i18n("blank entire disk"),0,mainw,SLOT(blankAll()),actionCollection(),"blank_all");
  (void) new KAction(i18n("fast blanking"),0,mainw,SLOT(blankFast()),actionCollection(),"blank_fast");
  (void) new KAction(i18n("blank track"),0,mainw,SLOT(blankTrack()),actionCollection(),"blank_track");

  (void) new KAction(i18n("unreserve track"),0,mainw,SLOT(blankUnreserve()),actionCollection(),"blank_unreserve");
  (void) new KAction(i18n("blank track tail"),0,mainw,SLOT(blankTail()),actionCollection(),"blank_tail");
  (void) new KAction(i18n("unclose last session"),0,mainw,SLOT(blankUnclose()),actionCollection(),"blank_unclose");
  (void) new KAction(i18n("blank last session"),0,mainw,SLOT(blankSession()),actionCollection(),"blank_session");
  //JW: Will stay as it is
  createGUI("kreatecdui.rc");


  /*


    menuBar()->insertItem(i18n("&Tools"),toolsmenu);
    menuBar()->insertSeparator();
    menuBar()->insertItem(i18n("&Help"),helpMenu(QString::null,false));
  */
  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("MainWindowGeo",&DefaultRect));

  setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding));
}


TopWidget::~TopWidget() {
  KConfig *config;
  QRect fgeo;

  fgeo=this->geometry();
  QRect SaveRect(fgeo.topLeft(),fgeo.size());

  config=kapp->config();
  config->setGroup("Geometry");
  config->writeEntry("MainWindowGeo",SaveRect);
}

void TopWidget::leaveMe(void) {
  this->close();
}
