// apply.cpp -- A program that applies strings to KDE *.desktop files
//
// 2001 by Niels Reedijk <n.reedijk@planet.nl>
//
// This file is subject to the terms and conditions of the GNU General
// Public License Version 2.  See the file COPYING in the main directory of the
// package for more details.

#include <iostream>
#include <qfile.h>
#include <qdir.h>
#include <qstringlist.h>
using namespace std;


int main( int argc , const char *argv[] )
{
  // We need at least one argument
  if ( argc == 1 )
  {
    cout << "Usage: " << argv[0] << " DESCRIPTION_FILE\n";
    return 1;
  }
  QFile descriptionFile( QDir::currentDirPath() + "/" + argv[1] );
  //First we're going to check which subdirs hold a copy of desktop.po
  QStringList subdirs , langs , desktops;
  subdirs = QDir::current().entryList( QDir::Dirs );
  if ( subdirs.count() == 0 )
  {
    cout << "There are no subdirs!\n";
    return 1;
  }
  for ( int i = 0 ; i < subdirs.count() ; i++ )
  {
    QDir check( QDir::currentDirPath() + "/" + subdirs[i] );
    QStringList files = check.entryList( "desktop.po" , QDir::Files );
    if ( files.count() == 0 )
      cout << "No desktop.po in " << subdirs[i] << endl;
    else if ( files.count() >= 2 )
      cout << "Multiple desktop.po's in " << subdirs[i] << "???\n" << endl;
    else
    {
      cout << "Found desktop.po in " << subdirs[i] << endl;
      langs << subdirs[i];
      desktops << check.path();
    }
  }
  if ( desktops.count() == 0 )
  {
    cout << "There aren't any desktop.po's in the subdirs. You must translate desktop.pot before you can apply the translations.\n";
    return 1;
  }
  //Time to process the found files
  if ( desktops.count() != langs.count() )
  {
    cout << "Internal error, report to the author\n";
    return 1;
  }
  for ( int i = 0 ; i < desktops.count() ; i++ )
  {
    QFile desktop_po( desktops[i] );
    if ( desktop_po.open( IO_ReadOnly ) )
    {
      

}
