// Copyright 2001 by Niels Reedijk <n.reedijk@planet.nl>
//
// This file is subject to the terms and conditions of the GNU General// Public License Version 2.  See the file COPYING in the main directory of the
// package for more details.

#include "MainWidget.h"

#include <kiconloader.h>
#include <krun.h>
#include <kconfig.h>
#include <klocale.h>

#include <qlabel.h>
#include <qpalette.h>
#include <qstring.h>
#include <qlistview.h>
#include <qfileinfo.h>

#include "MainWidget.moc"

MainWidget::MainWidget( QWidget *parent , const char *name , KURL aUrl)
          : MainWidget_skel( parent , name )
{
  KGlobal::locale()->insertCatalogue( "kreatecd_trackviewpart" );
  KIconLoader loader;
  loader.addAppDir( "kreatecd" );
  LeftTitlePic->setPixmap( loader.loadIcon( "kcd_logo" , KIcon::User ) );
  DownShadow->setPixmap( loader.loadIcon( "shadow1" , KIcon::User ) );
  MainText->setBackgroundPixmap( loader.loadIcon( "lines" , KIcon::User ) );
  url = aUrl;
  TrackList->setRootIsDecorated( true );
}

void MainWidget::setFile( KConfig *config )
{
  config->setGroup( "Global" );
  int tracks;
  tracks = config->readNumEntry( "Tracks" , 0 );
  if ( tracks == 0 )
    return;
  for ( int i = 0 ; i < tracks ; i++ )
  {
    QString Description , temp ;
    TrackType tracktype;
    config->setGroup( "Track" + Description.setNum( i + 1 ) );
    Description = config->readEntry( "Description" , "TRACK" );
    tracktype = (enum TrackType) config->readNumEntry( "Tracktype" , 2 );
    QListViewItem *item;
    switch (tracktype)
    {
      case 0:
        item = new QListViewItem( TrackList , temp.setNum( i + 1 ) , Description , i18n( "Audio Track" ) );
        break;
      case 1:
        item = new QListViewItem( TrackList , temp.setNum( i + 1 ) , Description , i18n( "Audio Preemphasised Track" ) );
        break;
      case 2:
        item = new QListViewItem( TrackList , temp.setNum( i + 1 ) , Description , i18n( "Data Track (mode 1)" ) );
        break;
      case 3:
        item = new QListViewItem( TrackList , temp.setNum( i + 1 ) , Description , i18n( "Data Track (mode 2)" ) );
        break;
      case 4:
        item = new QListViewItem( TrackList , temp.setNum( i + 1 ) , Description , i18n( "Data Track (XA mode 1)" ) );
        break;
      case 5:
        item = new QListViewItem( TrackList , temp.setNum( i + 1 ) , Description , i18n( "Data Track (XA mode 2)" ) );
        break;
      case 6:
        item = new QListViewItem( TrackList , temp.setNum( i + 1 ) , Description , i18n( "CD-I Track" ) );
        break;
      default:
        item = new QListViewItem( TrackList , temp.setNum( i + 1 ) , Description , i18n( "Audio Track" ) );
        break;
    }
    QString file;
    QListViewItem *subItem;
    file = config->readEntry( "SourceFile" , QString::null );
    if ( file != "" )
    {
      QFileInfo fileInfo( file );
      subItem = new QListViewItem( item , QString::null , fileInfo.fileName() , i18n( "Single File" ) , file );
    }
    else
    {
      //Check if it is a ISOTree like thing
      //TODO: This is a stub for translator use
      i18n( "Directory" );
    }
  }
}

void MainWidget::slotOpenKreateCD()
{
  KRun::runURL( url , "application/x-kreatecd" );
}
