/***************************************************************************
                          mempanel.cpp  -  description
                             -------------------
    begin                : Mon Dec 3 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlcddraw.h>

#include "barmeterpanel.h"



BarMeterPanel::BarMeterPanel(QWidget *parent, const char *name): Panel(parent,name)
{
 //
 barMeter= new QBarMeter(this);
 barMeter->move(6,6);
 barMeter->resize(6,52);
 barMeter->setDirection(QBarMeter::dirUp);
 barMeter->setSteps(13);
 barMeter->setValueColor( red );
 barMeter->setValueMaxColor( green );
 barMeter->installEventFilter(this);
 //
 lcdValue= new QLCDString(this);
 lcdValue->setGeometry(14,26,46,14);
 lcdValue->setShadow(true);
 lcdValue->setForegroundColor(red);
 lcdValue->setShadowColor(darkRed);
 lcdValue->installEventFilter(this);
 //
 sHeader= "";
 sFooter= "";
 setBarValue(0,0);
 //
}

BarMeterPanel::~BarMeterPanel()
{
}

void BarMeterPanel::setHeader(const QString &str)
{
 sHeader= str;
 update();
}

void BarMeterPanel::setFooter(const QString &str)
{
 sFooter= str;
 update();
}

void BarMeterPanel::setString(const QString &str)
{
 lcdValue->display(str);
}

void BarMeterPanel::setBarValue(int val)
{
 barMeter->setValue(val);
}

void BarMeterPanel::setBarValue(int val,int max)
{
 barMeter->setValueMax(max);
 barMeter->setValue(val);
}


// **********************

void BarMeterPanel::drawContents(QPainter *p)
{
 QLcd::draw(p, 15,7,47,9 ,sHeader.latin1(),QLcd::alignCenter,&darkGreen);
 QLcd::draw(p, 15,50,47,8,sFooter.latin1(),QLcd::alignCenter,&black);
}


