#ifndef KDIALUP_H
#define KDIALUP_H
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include <qobject.h> 

class KProcess;
class KWlanTrayWin;
class KWlanInterface;

class QString;
//class KWlanSuProcess;
//class KProcess;

class KDialup : public QObject
{
    Q_OBJECT
        
        
    public:
        KDialup(QObject * parent = 0, const char * name = 0 );
        ~KDialup();
    signals:
        void logEvent(QString event);
        void connectionEstablished();
        
    public slots:
        void connectNetwork(QString network);
        void slotConnect();
        void disconnectNetwork(QString network);
        void pppdStatus(KProcess *proc, char *buffer, int buflen);
        void interfaceEnable(bool enable);
        void close();

    private:
        bool m_connected;
        bool m_storePassword;
        bool m_connecting;
        QString m_pppdPath;
        QString m_pppInterface;
        QString m_network;
        KWlanTrayWin *m_traywin;
        KWlanInterface *m_interface;


};

#endif
