/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qpixmap.h>
#include <qpainter.h>
#include <qbuffer.h>
#include <qimage.h>
#include <kdebug.h>
#include "kxstitchmimesource.h"
#include "stitch.h"

KXStitchMimeSource::KXStitchMimeSource(QByteArray data)
  : m_data(data)
{
  m_outputFormats.append("application/kxstitch");
  QStrList ofmts = QImageIO::outputFormats();
  for (int i = 0 ; i < ofmts.count() ; i++)
  {
    QString f = QString("image/%1").arg(QString(ofmts.at(i)).lower());
    m_outputFormats.append(f.latin1());
  }
}

KXStitchMimeSource::~KXStitchMimeSource()
{
  // don't need to do anything here
}

const char* KXStitchMimeSource::format(int n) const
{
  if (m_outputFormats.count()<n)
    return 0;
  QStrListIterator it(m_outputFormats);
  while (n--)
    ++it;
  return it.current();
}

bool KXStitchMimeSource::provides(const char* mimeType) const
{
  int i;
  QStrListIterator it(m_outputFormats);
  for (i = 0 ; i < m_outputFormats.count() ; i++, ++it)
    if (qstrcmp(it.current(),mimeType) == 0) break;
  return i < m_outputFormats.count();
}

QByteArray KXStitchMimeSource::encodedData(const char* mimeType) const
{
  QPixmap       pixmap;
  QByteArray    data;
  QBuffer       buffer;
  QImageIO      io;
  QDataStream   read(m_data, IO_ReadOnly);
  QPainter      painter;
  QString       scheme;
  Q_INT32       width;
  Q_INT32       height;
  Q_INT8        count;
  Q_INT8        type;
  Stitch::Type  stitchType;
  Q_INT32       backstitches;
  Q_INT32       knots;
  QPoint        start;
  QPoint        end;
  QColor        color;
  if (qstrcmp(mimeType,"application/kxstitch") == 0)
  {
    data = m_data;
  }
  else
  {
    if (provides(mimeType))
    {
      read >> scheme >> width >> height;
      pixmap.resize(width*2,height*2);
      pixmap.fill();
      painter.begin(&pixmap);
      for (int dy = 0 ; dy < height ; dy++)
        for (int dx = 0 ; dx < width ; dx++)
        {
          read >> count;
          while (count--)
          {
            read >> type >> color;
            stitchType = (Stitch::Type)type;
            painter.setPen(color);
            if (stitchType & Stitch::TLQtr)
              painter.drawPoint(dx*2,dy*2);
            if (stitchType & Stitch::TRQtr)
              painter.drawPoint(dx*2+1,dy*2);
            if (stitchType & Stitch::BLQtr)
              painter.drawPoint(dx*2,dy*2+1);
            if (stitchType & Stitch::BRQtr)
              painter.drawPoint(dx*2+1,dy*2+1);
          }
        }
      read >> backstitches;
      while (backstitches--)
      {
        read >> start >> end >> color;
        painter.setPen(color);
        painter.drawLine(start,end);
      }
      read >> knots;
      while (knots--)
      {
        read >> start >> color;
        painter.setPen(color);
        painter.drawPoint(start);
      }
      painter.end();
      buffer.setBuffer(data);
      buffer.open(IO_WriteOnly);
      QString type = QString(mimeType);
      type = (type.remove(0,type.find('/')+1)).upper();
      io.setIODevice(&buffer);
      io.setFormat(type);
      io.setImage(pixmap.convertToImage());
      io.write();
      buffer.close();
    }
  }
  return data;
}
