/*
 *   LADCCA 
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ac-config.h"

#include <ladcca/ladcca.h>

#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gtk_client.h"

const char * filename = "ladcca_gtk_client.data";

static void print_help () {
  printf("LADCCA GTK Test Client version %s\n", PACKAGE_VERSION);
  printf("Copyright (C) 2002 Robert Ham <rah@bash.sh>\n");
  printf("\n");
  printf("This program comes with ABSOLUTELY NO WARRANTY.  You are licensed to use it\n");
  printf("under the terms of the GNU General Public License, version 2 or later.  See\n");
  printf("the COPYING file that came with this software for details.\n");
  printf("\n");
  printf(" -h, --help                  Display this help info\n");
  printf(" -f, --filename <filename>   Store data with LADCCA using the specified file name\n");
  printf("     --ladcca-port=<port>    Connect to server on port <port>\n");
  printf("\n");
}                            

int main (int argc, char ** argv)
{
  cca_args_t * cca_args;
  cca_client_t * cca_client;
  gtk_client_t * gtk_client;
  int opt;
  const char * options = "hf:";
  struct option long_options[] = {
    { "help", 0, NULL, 'h' },
    { "filename", 1, NULL, 'f' },
    { 0, 0, 0, 0 }
  };
  
  cca_args = cca_extract_args (&argc, &argv);

  gtk_set_locale ();
  gtk_init (&argc, &argv);
      
  while ((opt = getopt_long (argc, argv, options, long_options, NULL)) != -1)
    {
      switch (opt)
      {
      case 'f':
        filename = optarg;
        break;
      case 'h':
        print_help ();
        exit (0);
        break;

      case ':':
      case '?':
        print_help ();
        exit (1);
        break;
    }
  }
  
  cca_client = cca_init (cca_args, "LADCCA GTK Client", CCA_Config_Data_Set|CCA_Config_File,
                         CCA_PROTOCOL (2,0));

  if (!cca_client)
    {
      fprintf (stderr, "%s: could not initialise ladcca\n", __FUNCTION__);
      exit (1);
    }
  
  
  
  gtk_client = gtk_client_create (cca_client);
  
  gtk_main ();
  
  return 0;
}

