/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/

# ifndef LSYMBOLLIST_H
# define LSYMBOLLIST_H

abst_typedef struct _lsymbolList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ lsymbol  *elements;
} *lsymbolList ;

/*@iter lsymbolList_elements (sef lsymbolList x, yield lsymbol el); @*/
# define lsymbolList_elements(x, m_el) \
   { int m_ind; lsymbol *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { lsymbol m_el = *(m_elements++);

# define end_lsymbolList_elements }}

extern /*@only@*/ lsymbolList lsymbolList_new(void);
extern void lsymbolList_addh (lsymbolList p_s, lsymbol p_el) ;

extern void lsymbolList_free (/*@only@*/ lsymbolList p_s) ;

/*@constant int lsymbolListBASESIZE;@*/
# define lsymbolListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




