/*
 * $Id: arch_ia64.c,v 1.1 2004/12/21 23:26:17 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002, 2004 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

extern _command_t cmdset_ia64[];
extern _command_t cmdset_sn2[];

int
dumparch_init_ia64(FILE *ofp)
{
	int ret;

	if (!(ret = register_cmds(cmdset_ia64))) {
		/* If this is an sn2 dump, then load the
		 * sn2 only commands.
		 */
		if (KL_ARCH == KL_ARCH_IA64_SN2) {
			ret = register_cmds(cmdset_sn2);
		}
	}
	return(ret);
}
