#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#define DUMMY_MACRO_STRINGIFY(s) # s
#define STRINGIFY(s) DUMMY_MACRO_STRINGIFY(s)

#ifdef BFD_VERSION
#define KL_BFD_VERSION_STRING STRINGIFY(BFD_VERSION)
#else
#include <bfd.h>
#ifdef BFD_VERSION
#define KL_BFD_VERSION_STRING BFD_VERSION
#else
#define TMP_FILE ".out.bfd_version_test"
#endif
#endif

/* make sure that this macro is similarly defined in 
 * lcrash/include/lc_config.h
 */
#define _BFD_VERSION_NUMBER_(a,b,c) (((a) << 24) + ((b) << 12) + (c))

int main(void)
{
	int v1, v2, v3;
	char* tok;
	char* version;

#ifdef BFD_VERSION_STRING
	version=strdup(BFD_VERSION_STRING);
#else
#ifdef KL_BFD_VERSION_STRING
	/*
	 * in new versions bfd.h contains BFD_VERSION and BFD_VERSION_STRING,
	 * we still parse the version string to use our own version number
	 */
	version=strdup(KL_BFD_VERSION_STRING);
#else
	/* In even newer versions of bfd.h (e.g. 2.14.90) no VERSION macro is 
         * defined at all...
         * Use dirty hack and try to find out version of ld 
         * FIXME: Try to find a better method for bfd version checking!!!
         */
	{ 
		char buffer[1024] = {0};
		int fd;
		system("ld -v > "TMP_FILE);
		fd = open(TMP_FILE, O_CREAT);
		if(fd != -1){
			if(read(fd, buffer, 1024) == 0){
				perror("cannot read bfd version");
				close(fd);
				unlink(TMP_FILE);
				return(1);
			} else {
				version=strdup(buffer);
				sscanf(buffer, "GNU ld version %s\n",version);
				close(fd);
				unlink(TMP_FILE);
			}
		} else {
			perror("open failed");
			return(1);
		}
	}
#endif
#endif
	if(!version){
		return(1);
	}

	tok=strtok(version, ".");
	if(!tok){
		return(1);
	}

	v1=atoi(tok);

	tok=strtok(NULL, ".");
	if(!tok){
		return(1);
	}
	v2=atoi(tok);

	tok=strtok(NULL, ".");
	if(!tok){
                v3 = 0;
	}
	else v3=atoi(tok);

	printf("%d", _BFD_VERSION_NUMBER_(v1, v2, v3));
	return(0);
}
