#ifndef __env_h
#define __env_h

#include <stdlib.h>

#include "str.h"

static char *env_get(const char *s)
{
	/* Clib */
	return getenv(s);
}
static void env_put(char *k, char *v)
{
	str_t s;
	str_init(s);
	str_copy(s, k);
	str_cat(s, "=");
	str_cat(s, v);
	/* Clib */
	if (putenv(str(s)) == -1) {
		cfatal("env_put:putenv: %s");
	}
}

#endif
