#ifndef __ip_h
#define __ip_h

#include <sys/socket.h>
#include <fcntl.h>

#ifndef O_NONBLOCK
#define O_NONBLOCK O_NDELAY
#endif
static int inline ndelay_off(int fd)
{
	return fcntl(fd, F_SETFL, fcntl(fd, F_GETFL, 0) & ~O_NONBLOCK);
}
static int inline ndelay_on(int fd)
{
	return fcntl(fd, F_SETFL, fcntl(fd, F_GETFL, 0) | O_NONBLOCK);
}
static void inline socket_listen(int fd)
{
	if (listen(fd, 128) < 0)
		cfatal("listen: %s");
}
static void inline socket_tryreservein(int fd, int size)
{
	while (size >= 1024) {
		if (setsockopt(fd, SOL_SOCKET, SO_RCVBUF, &size, sizeof(size)) == 0)
			return;
		size -= (size >> 5);
	}
}


#ifdef HAVE_IPV6
#include "ip6.h"
#endif

#include "ip4.h"

#endif
