# Un-Indents the selected text by four spaces 
# if no text is selected, it will un-indent the whole buffer
# (C) 2001 Paul Evans <pevans@catholic.org> (under GPL)
# created from To_Lower.py

import string
import glimmer

if glimmer.has_selection():
    begin = glimmer.selection_start()
    end = glimmer.selection_end()
else:
    begin=0
    end= glimmer.buffer_size()
s = glimmer.get_text(begin,end)
glimmer.freeze()
glimmer.delete_text(begin,end)
glimmer.move_to(begin)


contentslist = string.split(s,'\n')
newlist = []
for n in contentslist:
    if n[:4] == ' '*4:
        newlist.append(n[4:])
    else:
        newlist.append(n)
s = string.join(newlist, '\n')



glimmer.insert(s)
glimmer.thaw()
