//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


// Implementation of the client_socket class

#include "client_socket.hpp"
#include "socket_exceptions.hpp"

namespace sockets
{

  client_socket::client_socket ( const std::string host, const int port )
  {
    if ( ! socket::create() )
      {
	throw socket_exception ( "Could not create client socket." );
      }

    if ( ! socket::connect ( host, port ) )
      {
	throw socket_exception ( "Could not connect to port." );
      }

  }


  const client_socket& client_socket::operator << ( const std::string& s ) const
  {
    if ( ! socket::send ( s ) )
      {
	throw socket_exception ( "Could not write to socket." );
      }

    return *this;
  }


  const client_socket& client_socket::operator >> ( std::string& s ) const
  {
    if ( ! socket::recv ( s ) )
      {
	throw socket_exception ( "Could not read from socket." );
      }

    return *this;
  }


};
