/* $Id: wizard.h,v 1.2 2005/03/24 10:27:25 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_GTKWIZARD_H
#define LING_GTKWIZARD_H 1

#include "../li18n.h"
#define WIZARD_TEXT_NEXT N_("After you have finished your selection, click " \
                            "\"Next\".")

typedef GtkWidget* (*WizPageCallback) (gpointer data);
typedef gboolean (*WizardCallback) (gpointer data);

GtkWidget*
wizard_create_new (const gchar *title, const gchar *init_text);


void
wizard_append_page_with_callbacks (GtkWidget *wizard, const gchar *title, 
                                   WizPageCallback page_cb, gpointer page_data,
                                   WizardCallback callback, gpointer data);
#define wizard_append_page(wiz, title, page_cb, page_data) \
    wizard_append_page_with_callbacks(wiz,title,page_cb,page_data,NULL,NULL)


gint
wizard_run (GtkWidget *wizard);

#endif /* LING_GTKWIZARD_H */
