/***************************************************************************
                          crxselect.cpp  -  description
                             -------------------
    begin                : Sun Oct 22 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "crxselect.h"

CRxSelect::CRxSelect(int columns,QWidget *ControlWidget,QWidget *parent, const char *name ) : QButtonGroup(parent,name)
{
setFrameStyle(QFrame::WinPanel | QFrame::Raised);
	setRadioButtonExclusive(true);
	QVBoxLayout *vbox=new QVBoxLayout(this,-1);
	vbox->setMargin(5);

		for(int i=0;i < columns; i++)
				{

					QRadioButton	*rb= new QRadioButton(this);
					
					rb->setText(QString::number(i+1));
					vbox->addWidget(rb);
					setColor(i);
				}
	setButton(0);
	connect(this,SIGNAL(clicked(int)),ControlWidget,SLOT(selectRxWindow(int)));

}
CRxSelect::~CRxSelect()
{
}

void CRxSelect::resizeEvent(QResizeEvent *e)
{
int NumberofButtons;
int height;
NumberofButtons=count();
height=(this->height()-5)/NumberofButtons;


for (int i=0;i<NumberofButtons;i++)
		 	find(i)->setFixedHeight(height);	
	
}
/** Select RxWindow as Slot Function */
void CRxSelect::selectRxWindow(int i)
{
setButton(i);
emit clicked(i);
}
/** sets the color of the button */
void CRxSelect::setColor(int ButtonNumber)
{
	QPalette p=this->palette();	
	
	QButton *rb;
	rb=this->find(ButtonNumber);
	
	p.setColor(QColorGroup::Foreground,settings.colours[ButtonNumber]);
					
	rb->setPalette(p);

}
