/***************************************************************************
                          ctxwindow.cpp  -  description
                             -------------------
    begin                : Sun Mar 5 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "ctxwindow.h"


CTxwindow::CTxwindow (QWidget *parent, const char *name ) : QMultiLineEdit(parent,name)
{

inpos=0;
outpos=0;
filled=0;

}
CTxwindow::~CTxwindow(){
}

void CTxwindow::keyPressEvent(QKeyEvent *e)	// Bearbeiten der Eingaben im
																						// TX Window
{
unsigned char c;
static bool CapsLock = false;
if (filled < TXBUFFER_LENGTH)
	{
		switch(e->key())
		{
			case Key_Enter:
			case Key_Return:
			
				cursorPosition(&akt_line,&akt_col);
				akt_line++;
				if(akt_line >= maxline)
					removeLine(0);	//Erste Zeile entfernen
					
					newLine();
					c='\n';
				e->accept();
				filled++;
				txbuffer[inpos++]=c;
				inpos = inpos % TXBUFFER_LENGTH;
      break;
			
			case Key_CapsLock:	
				CapsLock = !CapsLock;
				e->accept();
				break;
				

				case Key_Backspace:
				c='\b';
				backspace();
				e->accept();
				if (filled > 0)
					{ 				// We can delete the last char direct in the buffer
						filled--;
						inpos = inpos + TXBUFFER_LENGTH - 1;
					}
				else
					{
						filled++;
						txbuffer[inpos++]=c;
					}
				inpos = inpos % TXBUFFER_LENGTH;

				break;

				default:	
				if ( (e->state() == ShiftButton) || CapsLock)
				c=toupper(e->ascii());
				else
				c=tolower(e->ascii());
				if ( c !=0 )
					{
					cursorPosition(&akt_line,&akt_col);
					akt_col++;
					if (akt_col >80)
						{
						insertCntrlChar('\n'); //This newline Char will  be Transmitted
						newLine();
						}
					insertChar(c);
					e->accept();
					filled++;
					txbuffer[inpos++]=c;
					inpos = inpos % TXBUFFER_LENGTH;
  				}
				} // End Case

		}
	else
	{
		QApplication::beep();
		e->ignore();
	}

} // keyPressEvent

int CTxwindow::getTxChar(void)
{
int ch;
if (filled > 0)
	{
		ch=txbuffer[outpos++];
		filled--;
		if (filled == 0)
			{
				inpos=0;
				outpos=0;
			}
		 else
			outpos=outpos % TXBUFFER_LENGTH;
		if (ch == TXOFF_CODE)
			settings.status=TX_POSTAMBLE_STATE;
		return ch;
	}
else
	 return TXTOG_CODE;

}

int CTxwindow::insertTxChar(const char *txtstring, int anzahl)

{
int len;
int i;
len = TXBUFFER_LENGTH-filled;
if(len == 0)
	 return len; //TXBuffer full; try later

if (len > anzahl)
	len =anzahl;

for (i=0;i < len;i++)
 {
	txbuffer[inpos++]= *(txtstring+i);
	inpos=inpos % TXBUFFER_LENGTH;
	}
filled +=len;
return len;
}	

void CTxwindow::insertCntrlChar(int CntrlChar)

{
while (filled >= TXBUFFER_LENGTH)
	qApp->processEvents(100);
filled++;
txbuffer[inpos++]= CntrlChar;
inpos %= TXBUFFER_LENGTH;
return;
}

bool CTxwindow::TxBufferisEmpty(void)
{
if (filled == 0 )
return true; //Buffer is empty
else
return false; // Some Char's to xmit
}

void CTxwindow::setMaxLine(int count)

{
maxline=count;
}
