/***************************************************************************
                          setup.cpp  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/
#include "setup.h"

extern bool checkcom(char *s);
extern int getVolume(int Device);
extern int getOutputVolume();

Setup::Setup(QWidget *parent, const char *name) : FSetup(parent,name,TRUE)
{
QString s;

// DemoMode
  demoMode=settings.DemoMode;
	DemoMode->setChecked(demoMode);
	if (demoMode)
	{
		DemoInputMode->show();
		DemoInputMode->setButton(settings.DemoTypeNumber);
	}	
else
	DemoInputMode->hide();	

// Callsign
	
  UserCallSign->setText(settings.callsign);

// Station File
	SendFile->setText(settings.StationFile);

// TimeOffset
  TimeOffset->setText(s.setNum(settings.timeoffset));

// UserDefined Button
	ButtonName->setText(settings.ButtonName);

// Corresponding ButtonFile
	ButtonFile->setText(settings.ButtonFile);
// Input Source (Ugly coding)
	if (settings.InputSource == SOUND_MIXER_MIC)
	InputSelect->setButton(0);
		if (settings.InputSource == SOUND_MIXER_LINE)
	InputSelect->setButton(1);
	InputSource = settings.InputSource;
	setInputSource(InputSource);

// InputLevel
	level = getVolume(settings.InputSource);
	InputLevel->setValue(level);
	
// OutputLevel
	OutputLevel->setValue(getOutputVolume());

// slashedZero
	slashed0=settings.slashed0;
	slashedZero->setChecked(slashed0);


//  PTTControl
	if(!checkcom("/dev/ttyS0"))
		Com1->hide();
		

	if(!checkcom("/dev/ttyS1"))
		 Com2->hide();

  if(!checkcom("/dev/ttyS2"))
		Com3->hide();


	if(!checkcom("/dev/ttyS3"))
		Com4->hide();
  ptt=settings.ptt;
	PTTControl->setButton(ptt);

// Number of receive windows
  RxChannels->setValue(settings.RxChannels);
	
}

Setup::~Setup(){
}

/** Sets the Demomode on or off */
void Setup::setDemoMode(bool mode)
{
demoMode=mode;
}


void Setup::setComPort(int port)
{
ptt=port;
}

void Setup::setSlashed0(bool zero)
{
slashed0=zero;
}


void Setup::setInputLevel(int SelectedLevel)

{
	level=SelectedLevel;
	setVolume(InputSource,level);
}


void Setup::setOutputLevel(int level)

{
	setOutputVolume(level);
}
/** Activates/Deactivates the SubWindow for the different Demo's */
void Setup::activateTypeWindow(bool type)
{
if (type)
	{
		DemoInputMode->show();
		demoMode= true;
	}	
else
	{
		DemoInputMode->hide();
		demoMode = false;
	}	
}
/** Selects the type of the input file
1 wav
2 text , sample rate 11025 */
void Setup::selectDemoType(int type)
{
 DemoTypeNumber = type;

}

void Setup::selectInput(int source)
{
if (source == 0)
	{
		setInputSource(SOUND_MIXER_MIC);
		InputSource=SOUND_MIXER_MIC;
	 }	
if (source == 1)
	{
		setInputSource(SOUND_MIXER_LINE);	
		InputSource=SOUND_MIXER_LINE;
	}	
	
setInputLevel(level);	
}
