/***************************************************************************
                          cpanel.cpp  -  description
                             -------------------
    begin                : Sun Mar 5 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "cpanel.h"

CPanel::CPanel(QWidget *parent, const char *name):QFrame(parent,name)

{

int ButtonHeight,ButtonWidth;
QFontMetrics fm(settings.PanelLabelFont);

ButtonHeight=fm.height()+2;
setFontPropagation(AllChildren);
setFont(settings.PanelLabelFont);

setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
setMargin(5);


// Generating Sub- Windows , beginning top left -> down and so on


header = new QTabBar(this);
// Generate tabs
spectrum = new QTab("Spectrum");

waterfall = new QTab("Waterfall");

input = new QTab("Input");

/*datasync=new QTab();
datasync->label="Data Sync";*/


header->setShape(QTabBar::RoundedAbove);
// Add tabs
tablist[0]=header->addTab(spectrum);
tablist[1]=header->addTab(waterfall);
tablist[2]=header->addTab(input);
//tablist[3]=header->addTab(datasync);

// Tuning Display in Control Panel

display = new CDisplay(this);

//Swittching Display Type
   connect(header,SIGNAL(selected(int)),display,SLOT(selecttab(int)));
	 connect(header,SIGNAL(selected(int)),this,SLOT(viewchanged(int)));

	

// Subscripts
lminfreq=new QSpinBox(display->minfreq,1000,100,this);
lminfreq->setSuffix(" Hz");
lminfreq->setValue(display->minfreq);

lmaxfreq=new QSpinBox(1100,display->maxfreq,100,this);
lmaxfreq->setSuffix(" Hz");
lmaxfreq->setValue(display->maxfreq);

// Change Display Scaling
	connect(lminfreq,SIGNAL(valueChanged(int)),display,SLOT(scaleminfreq(int)));
	connect(lmaxfreq,SIGNAL(valueChanged(int)),display,SLOT(scalemaxfreq(int)));	

		
slow= new QRadioButton(this,"slow");
slow->setText("Slow");

// Changing smoothing filter for FFT
		connect(slow,SIGNAL(toggled(bool)),display,SLOT(filtertype(bool)));


// right side of Control- Panel
// Grouping QSO Infos

QSOInfo =new QGroupBox(1,Horizontal,"QSOInfo",this);
QSOInfo->setLineWidth(1);
QSOInfo->setMargin(1);
QSOInfo->setMidLineWidth(0);
// Remote Call

TheirCallL = new QLabel("Remote Call",QSOInfo);
theircall = new QLineEdit(QSOInfo);
connect(theircall,SIGNAL(textChanged(const QString &)),this,SLOT(saveTheirCall(const QString &)));

// Remote OP's Name
NameL= new QLabel("Name",QSOInfo);
Name=new QLineEdit(QSOInfo);
connect(Name,SIGNAL(textChanged(const QString &)),this,SLOT(saveName(const QString &)));

ButtonWidth=fm.width(tr("Clear RxWindow"))+5;

// Tune
Tune = new QPushButton(this);
Tune->setFixedSize(ButtonWidth,ButtonHeight);
Tune->setText("Tune (F8)");

// CW ID
CWID = new QPushButton(this);
CWID->setFixedSize(ButtonWidth,ButtonHeight);
CWID->setText("CW ID (F6)");

// Clear Rx Window
Clear = new QPushButton(this);
Clear->setFixedSize(ButtonWidth,ButtonHeight);
Clear->setText("Clear RxWindow");

// Clear QsoInfo
ClearQsoInfo = new QPushButton(this);
ClearQsoInfo->setFixedSize(ButtonWidth,ButtonHeight);
ClearQsoInfo->setText("Clear QsoInfo");

connect(ClearQsoInfo,SIGNAL(clicked()),this,SLOT(clearQsoInfo()));

//Macros
ButtonWidth=fm.width(" Send StationFile ")+5;
Macros = new QButtonGroup(6,Vertical,this);
Macros->setFixedSize(ButtonWidth+20,8*ButtonHeight+16);
Macros->setFontPropagation(AllChildren);
Macros->setTitle("Macros ");

QSOStart=new QPushButton(Macros);
QSOStart->setFixedSize(ButtonWidth,ButtonHeight);
QSOStart->setText("(F11) QSO Start");

QSOBTU=new QPushButton(Macros);
QSOBTU->setFixedSize(ButtonWidth,ButtonHeight);
QSOBTU->setText("(F12) QSO BTU");


Final=new QPushButton(Macros);
Final->setFixedSize(ButtonWidth,ButtonHeight);
Final->setText("QSO Final");

CQ= new QPushButton(Macros);
CQ->setFixedSize(ButtonWidth,ButtonHeight);
CQ->setText("CQ");

SendFile = new QPushButton(Macros);
SendFile->setFixedSize(ButtonWidth,ButtonHeight);
SendFile->setText("Send StationFile");

UserDefined = new QPushButton(Macros);
UserDefined->setFixedSize(ButtonWidth,ButtonHeight);
UserDefined->setText(settings.ButtonName);


}
CPanel::~CPanel(){
}

void CPanel::viewchanged(int view)
{
switch (view)
	{
	case SPECTRUM:
	case WATERFALL:
		lminfreq->show();
		lmaxfreq->show();
		slow->show();
		break;
	default:
		lminfreq->hide();
		lmaxfreq->hide();
		slow->hide();
		break;
   }
}



void CPanel::saveTheirCall(const QString &s)
{
settings.theircall =theircall->text();
}


void CPanel::NameChanged()
{
UserDefined->setText(settings.ButtonName);

}

void CPanel::resizeEvent(QResizeEvent *e)
{

int xpos,ypos;


xpos=5;
ypos=height()-30;
// Subscripts of Display
// left
lminfreq->setGeometry(xpos,ypos,70,20);

// header of Display
ypos=height()/20;
header->setGeometry(xpos,ypos,(width()*4)/10,2*ypos);

// Position Display
display->move(header->x(),header->y()+header->height());

// Resize Display
display->resize(header->width(),lminfreq->y()-header->y()-header->height()-10);

//middle
slow->setGeometry(display->x()+display->width()/2-30,height()-30,60,20);
//right
lmaxfreq->setGeometry(header->x()+display->width()-70,height()-30,70,20);



//Buttons right of Display
///////////////////////////////
xpos=display->x()+display->width()+5;
// Tune
Tune->move(xpos,display->y());

// Send CW ID
CWID->move(xpos,Tune->y()+Tune->height()+5);

// Clear RxWindow
Clear->move(xpos,CWID->y()+CWID->height()+5);

// Clear QsoInfo
ClearQsoInfo->move(xpos,Clear->y()+Clear->height()+5);

// Macros in the right Side of Panel
Macros->move(width()-Macros->width()-5,5);

// We fit QSOInfo between Tune and Macros
xpos=xpos+Tune->width()+5;
ypos=Macros->x()-xpos-5;
QSOInfo->setGeometry(xpos,Macros->y(),ypos,Macros->height());
//Remote Call
theircall->setFixedSize(ypos-20,Tune->height());
TheirCallL->setFixedSize(ypos-20,theircall->height());
// Remote Op's name
Name->setFixedSize(ypos-20,theircall->height());
NameL->setFixedSize(ypos-20,theircall->height());

}

void CPanel::saveName(const QString &s)
{
settings.Name=Name->text();


}
/** copies the marked string from the active RX window to Remote Call or Name
depending on which window has the focus
If no windo has the focus the Remote call is taken */
void CPanel::setString(const QString  &String)
{
if (theircall->hasFocus())
	theircall->setText(String);
else
	{
		if (Name->hasFocus())	
			Name->setText(String);
		else
		theircall->setText(String); //default, if no one has focus
	}		

}
/** Clears the Fields fin QSOInfo */
void CPanel::clearQsoInfo()
{
theircall->setText("");
Name->setText("");
settings.setTheirCall("");
settings.setName("");

}
