/***************************************************************************
                          linpskview.h  -  description
                             -------------------
    begin                : Sat Mar  4 22:29:25 /etc/localtime 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/

#ifndef LINPSKVIEW_H
#define LINPSKVIEW_H

// include files for QT
#include <qwidget.h>
#include <qtimer.h>
#include <qstatusbar.h>
#include <qlabel.h>
#include <qdatetime.h>

#include <qmessagebox.h>
#include <qkeycode.h>
#include <qaccel.h>

#include <qfile.h>
#include <qtextstream.h>
#include <qregexp.h>

// application specific includes

//#include "crxdisplay.h"
#include "ctxdisplay.h"
#include "cpanel.h"
#include "parameter.h"
//#include "pskdet.h"

#include "csound.h"
#include "textinput.h"
#include "waveinput.h"
#include "cledbutton.h"
#include "bpskdemodulator.h"
#include "qpskdemodulator.h"
#include "rttydemodulator.h"

#include "cmodulator.h"
#include "rttymodulator.h"


extern Parameter settings;

class Input;
/**
 * This class defines the  application view.
 */

class LinPskView : public QWidget
{
  Q_OBJECT
  public:

     LinPskView(QWidget *parent=0);
    ~LinPskView();
void AddGaussian(double * pData, int n, double std);
		void initRxChannels(int from,int to);
		/* Stops the current activity */
		void stopAll();
Input *sound;

// Window - Components

CRxdisplay *rx[4];
CDemodulator *demodulator[4];

CTxdisplay	*tx;
CPanel 		*controls;

QStatusBar *statusBar;
QLabel *msg;
// Timer for idle loop for receiving and Transmitting

QTimer *rxtimer;
QTimer *txtimer;

protected:

void resizeEvent(QResizeEvent *);


protected slots:
public slots: // Public slots
  /** Reading and processing Data from input source */
  void process_rxdata();
	/** Processing txdata and writing to Soundcard*/
	void process_txdata();
  /** Starting receiving/transmitting */
  void start_process_loop();
	/** Show Time */
	void setclock();
	/** excute Macr0 */
	void executeMacro(int);
	/** executeMacro0 */
	void executeMacro0();
	/** executeMacr01 */
	void executeMacro1();
	/** Send CW ID */
	void SendCWid();	
	/** Tune */
	void Tune();
	/** Select appropriate Rx- Window*/
	void selectRxWindow(int);
	/** Change RxFrequency of apprpriate RxWindow */
	void rxfreqchanged(int);
  /** changes the Demodulator to the new Mode */
  void setMode(Mode,int);
signals: // Signals
  /** Stop PSK31 in case of unrecoverable error */
  void abbruch();
private:

   /** Decimation Filter to reduce samplerate */
  void ProcDec2Fir(double *pIn, double *pOut,int BlockSize);
	void sendString(const char *);

 double *inbuf;	//Input Buffer
 double *dec2fir; // queue for decimation by 2 filter
 double *outbuf; // outputbuffer
 double *m_pDec2InPtr;

 CModulator *Modulator;
	int txcount; // Number of transmitted Data; 0 if Soundcard Buffer is full;	
/** Some Labels in the Statusbar*/
#ifndef AFC_DEBUG
QLabel *clockadj;
#endif
QLabel *datum;
QLabel *zeit;
QLabel *IMD;

/** For Debugging AFC */
#ifdef AFC_DEBUG
QLabel *Error;		// Total
QLabel *Df;				// Frequency component
QLabel *Dp;				// Phase component
#endif

QAccel * functions;

QString prepareMacro(QString Macro);

bool processingMacros; // To ensure that Macro will be completly execute
};

#endif
