/***************************************************************************
                          rttydemodulator.h  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef RTTYDEMODULATOR_H
#define RTTYDEMODULATOR_H

#include <cdemodulator.h>
#include <complex.h>

/**Decodes RTTY 
  *@author Volker Schroer
  */
enum StateOfReception { WaitingForMark,WaitingForSpace, CheckingStartBit,SkipRestOfStartBit,CollectingByte,
												 CheckingParity, WaitingForStopBits,ThrowHalfBit};
/** Number of tones used in fsk (2 for Rtty) but we use 7 for doing some afc */

#define  NumberofTones 7

class RTTYDemodulator : public CDemodulator  {
public: 
	RTTYDemodulator();
	~RTTYDemodulator();

	/** Prozess the input */
	void ProcessInput(double * input);
	
	bool Init(double,int);
	
public slots: // Public slots
/** Set RxFrequencies for RTTY */
void setRxFrequency(double);

private: 	//Private Variables

/** coeficients for slidding fft */
float_complex *twiddles;

/** result of slidding fft for the different tones */
float_complex *bins;
/** history of sampled values for fft */
float *history;
/** Mapping of Frequency to integer number (index) */
int *FrequencyNumber;

/** Number of samples to process */
int NxSamples;
/** Actuell Sample , just to be processed */
int actSample;
/** Adress of data */
double *data;

/** SampleRate */
double SampleRate;

/** Status of Shift */
bool ShiftOn;

/** Baudrate */
int Baudrate;
/** Number of Stopbits */

unsigned int NumberOfStopBits;

/** Parity
	0 none
	1 even
	2 odd	*/
unsigned int parity;
/** Samples per bit */
unsigned int SamplesPerBit;
/** Number of Bits per Character */
unsigned int NumberOfBits;

bool DataAvailable;

/** Status of reception*/
StateOfReception Status;

/** Pointer to history */
int ptr;

/** Counts the number of bits in act. Character ( for parity) */
unsigned int BitsInData;
/** Number of Bits to be processed */
int bitcounter ;
/** Bitpattern of actual processed byte */
int c;
/** has detected Frequency changed ? */
bool FrequencyChanged;
/** How to correct the Rxfrequency */
int Frequencykor;
/** previous sample */
int x1;
/** Sample position in bit */
unsigned int count ;
/** Variables for Squelch computing */
float ave1,ave2;


private: // Private methods
  /** returns the asci char coresponding to the baudot code */
  char baudot_code(char);
  /** Processes the next sample */
  int ProcessNextSample();
  /** gets the next bit */
  bool get_next_bit();
	/** Sliding fft */
	void slfft(float);
	/** Calc the quality of the signal for squelch */
	void CalcQuality();
	/** Reset the values of sliding of fft */
	void reset();
};

#endif
