/* #Specification: kernel modules / list
	Linuxconf present kernel module organised in list. The file
	/usr/lib/linuxconf/kmodules.list provide the list of all available
	modules (known one). The format of this file goes like this

	#
	:catagory
	module1	desc ...
	module2 desc ...
	:Othercateg
	module3 desc
	#

	Where the various category are scsi, net, pcmcia etc...

	After reading that file, linuxconf execute /sbin/modprobe -l to
	retrieve the list of all available module on this system.
	The various list will try to make visible which module is available
	or not.
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <misc.h>
#include <netconf.h>
#include <daemoni.h>
#include <popen.h>
#include "askrunlevel.h"
#include "../paths.h"

static CONFIG_FILE f_modl (USR_LIB_LINUXCONF "/kmodule.list"
	,help_nil
	,0);

/*
	Obtain the list of kernel module and a description
*/
int modlist_get (
	const char *type,		// Type of kernel modules net,scsi,...
	SSTRINGS &tbmod,		// Will contain the name of each kernel modules
	SSTRINGS &tbdesc,		// Will contain a short description
	char tbavail[300])		// Will tell if the module is available on
							// this system
{
	int ret = -1;
	FILE_CFG *fin = f_modl.fopen ("r");
	if (fin != NULL){
		char buf[500];
		bool reading = false;
		ret = 0;
		SSTRINGS avail;		// List of module available on this system
		{
			DAEMON_INTERNAL *dae = daemon_find ("modprobe");
			if (dae->is_managed()){
				char cmd[PATH_MAX];
				sprintf (cmd,"%s -l",dae->getpath());
				POPEN pop (cmd);
				for (int i=0; i<10; i++){
					int code = pop.wait(1);
					if (code==-1){
						break;
					}else if (code == 1){
						char line[PATH_MAX];
						while (pop.readout(line,sizeof(line))!=-1){
							char *pt = strrchr(line,'/');
							if (pt != NULL){
								pt++;
								char *end = strstr (pt,".o");
								if (end != NULL) *end = '\0';
								avail.add (new SSTRING(pt));
							}
						}
					}
				}
			}
		}
		while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			strip_end (buf);
			if (buf[0] != '\0'){
				if (buf[0] == ':'){
					if (reading){
						break;
					}else if (strcmp(type,buf+1)==0){
						reading = true;
					}
				}else if (reading){
					char module[100];
					char *desc = str_copyword (module,buf,sizeof(module));
					desc = str_skip(desc);
					tbmod.add (new SSTRING(module));
					tbdesc.add (new SSTRING(desc));
					tbavail[ret] = avail.lookup(module)!=-1;
					ret++;
				}
			}
		}
		fclose (fin);
	}
	return ret;
}

void modlist_dummy(){}

static CONFIG_FILE f_irql (PROC_INTERRUPTS,help_nil,0);

int irqlist_get (SSTRING tb[16])
{
	int ret = -1;
	FILE_CFG *fin = f_irql.fopen ("r");
	if (fin != NULL){
		char buf[500];
		ret = 0;
		while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			char word[3][100];
			char *pt = str_copyword (word[0],buf,sizeof(word[0]));
			pt = str_copyword (word[1],pt,sizeof(word[1]));
			pt = str_skip(pt);
			char *pt2 = str_copyword (word[2],pt,sizeof(word[2]));
			int irq = atoi(word[0]);
			if (strcmp(word[2],"+")==0){
				pt = str_skip(pt2);
			}
			strip_end (pt);
			if (irq >= 0 && irq < 16){
				tb[irq].setfrom (pt);
			}
		}
		fclose (fin);
	}
	return ret;
}


