#!/bin/sh
# This script try to stuff linuxconf base configuration out
# of suse specific configuration files
echo Probing S.u.S.E specific information
echo
. /etc/rc.config
if [ "$NETCONFIG" = "" ] ; then
	echo No main network device
	netconf --setdevdef 0 $FQHOSTNAME 127.0.0.1 "" ""
else
	echo Networking is enabled
	for dev in $NETCONFIG
	do
		eval DEVICE=\$NETDEV$dev
		eval IPADDR=\$IPADDR$dev
		eval IFCONFIG=\$IFCONFIG$dev

		echo $IFCONFIG >/tmp/grabinfo.tmp
		read skip skip skip skip NETMASK skip </tmp/grabinfo.tmp

		if [ "$dev" = "_0" ] ; then
			echo "Main network device  is" $DEVICE
			echo "Setting hostname     to" $FQHOSTNAME
			echo "Setting IP address   to" $IPADDR
			echo "Setting netmask      to" $NETMASK
			netconf --setdevdef 0 $FQHOSTNAME $IPADDR $NETMASK $DEVICE
		fi
	done
fi

# ip 07.12.1998 deactivated, is automatically managed...
#
#if [ -f /etc/route.conf ] ; then
#	LINE=`grep -v '#' /etc/route.conf | grep default`
#	if [ "$LINE" != "" ] ; then
#		echo $LINE >/tmp/grabinfo.tmp
#		read skip GATEWAY skip </tmp/grabinfo.tmp
#		netconf --setgateway $GATEWAY
#		echo "Setting gateway      to" $GATEWAY
#	fi
#fi
#
#if [ "$GMT" != "" ] ; then
#	echo "CMOS clock mode set  to" gmt
#	netconf --setclockmode gmt
#else
#	echo "CMOS clock mode set  to" local
#	netconf --setclockmode local
#fi
#
#if [ "$KEYTABLE" = "" ] ; then
#	echo No keytable defined
#else
#	echo Keyboard mapping set to $KEYTABLE
#	linuxconf --setkeymap $KEYTABLE
#fi
#

