#!/bin/sh
if [ $# = 0 ] ; then
	echo
	echo inithelplang.sh language_id
	echo
	echo This will setup a directory \"language_id\" ready
	echo to translate the help messages.
	echo
	echo If the language directory already exist, this script
	echo will make sure that it contain the latest sub-directory
	echo This means that you can run this script twice and it won\'t
	echo be confused\!
	echo
elif [ ! -f scripts/inithelplang.sh ] ; then
	echo
	echo inithelplang.sh must be executed from the help.files directory
	echo
else
	if [ -d $1 ] ; then
		echo
		echo Language $1 is already setupped
		echo Checking that it is up to date
		echo
	else
		mkdir $1
	fi
	cd sources
	for dir in *
	do
		if [ -d $dir ] ; then
			if [ ! -d ../$1/$dir ] ; then
				echo "    " creating $1/$dir
				mkdir ../$1/$dir
				(cd ../$1/$dir \
					&& ln -s ../../sources/$dir/Makefile Makefile \
					&& ln -s ../../sources/$dir/FILE_LIST FILE_LIST)
			else
				echo "      " $1/$dir already exist: Ok\!
			fi
		fi
	done
fi

