#pragma implementation
#include <stdio.h>
#include <limits.h>
#include <dlfcn.h>
#include "libmodules.h"
#include "misc.h"
#include "misc.m"

LIBMODULE::LIBMODULE(char *name)
{
	char path[PATH_MAX];
	snprintf (path,sizeof(path)-1
		,"/usr/lib/linuxconf/libmodules/lib%s.so.%s.%d",name
		,LINUXCONF_REVISION,LINUXCONF_SUBREVISION);
	//fprintf (stderr,"libmodule %s\n",name);
	handle = dlopen(path,RTLD_LAZY|RTLD_GLOBAL);
	if (handle == NULL){
		xconf_error (MSG_R(E_LOADMOD),path,dlerror());
	}else{
		linuxconf_loadmsg (name,PACKAGE_REV);
	}
}

LIBMODULE::~LIBMODULE()
{
	if (handle != NULL)
		dlclose(handle);
}

bool LIBMODULE::loaded()
{
	return (handle != NULL);
}

// Just to force the linkage
void libmodules_required()
{
}

// vim:nowrap
