#!/bin/sh
SSLBIN=/usr/local/ssl/bin
if [ ! -x $SSLBIN/openssl ] ; then
	SSLBIN=/usr/bin
fi
if [ -x $SSLBIN/openssl ] ; then
	umask 077
	if [ `id -u` = 0 ] ; then
		SAFEDIR=/var/run
	else
		# Not run as root, I guess the HOME is the only safe place
		SAFEDIR=$HOME
	fi
	KEY=$SAFEDIR/linuxconf-apache-key.pem
	REQ=$SAFEDIR/linuxconf-apache-req.pem
	mkdir -p /etc/linuxconf
	CERT=$1
	#echo `date` avant key ok >>/tmp/ssl.log
	if $SSLBIN/openssl genrsa -des3 1024 > $KEY
	then
		#echo `date` key ok >>/tmp/ssl.log
		if $SSLBIN/openssl req -x509 -key $KEY -new > $REQ
		then
			#echo `date` req ok >>/tmp/ssl.log
			cat $REQ $KEY >$CERT
			#echo `date` apres cat >>/tmp/ssl.log
			exit 0
		fi
	#else
		#echo `date` key fail >>/tmp/ssl.log
	fi
else
	echo The command openssl is not available >&2
fi
exit 1



