
/* this configuration deals with the 'realms' file */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "radiusconf.h"
#include "radiusconf.m"

#include "rc_parser.h"
#include "rc_tools.h"

// char var id, flag name, description
#define EASY_FLAG(a,b,c) char a;\
    a=is_this_flag_present(flagdata.get(), b);\
    my_dialog.newf_chk("", a, c)

// char var id, flag name
#define EASY_FLAG_WRITE(a,b) \
    set_flag_accordingly(flagdata, b, a)

/* used in options' settings */
/* return !=0 if present */
char is_this_flag_present(const char *given_string, const char *given_flag)
{
    int my_loop=0;
    SSTRING current_item;

    while(gimme_word_from_string(given_string, current_item, my_loop++)){
        if(!ci_strcmp(current_item.get(), given_flag))
            return(1);
    }
    return(0);
}

/* used in options' settings */
/* remove flag if present */
void remove_this_flag(SSTRING &change_this, const char *given_flag)
{
    int my_loop=0, written_flags=0;
    SSTRING current_item;
    SSTRING final_string;

    while(gimme_word_from_string(change_this.get(), current_item, my_loop++)){
        if(ci_strcmp(current_item.get(), given_flag)){
            if(written_flags)
                final_string.append(" ");
            final_string.append(current_item.get());
            written_flags++;
        }
    }
    change_this.setfrom(final_string.get());
}

/* used in options' settings */
void add_this_flag(SSTRING &change_this, const char *given_flag)
{
    if(!is_this_flag_present(change_this.get(), given_flag)){
        if(!is_empty_string(change_this.get()))
            change_this.append(" ");
        change_this.append(given_flag);
    }
}

/* used in options' settings */
void set_flag_accordingly(SSTRING &change_this, const char *given_flag, char given_data)
{
    if(given_data){
        add_this_flag(change_this, given_flag);
    }else{
        remove_this_flag(change_this, given_flag);
    }
}

void edit_realms_entry(VIEWITEMS &given_vitems, int which_one)
{
    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    SSTRING     dialog_title;

    /* loads vars.. */
    /* builds gui.. */

    /* realm name */
    EASY_STR2(realmdata,0,MSG_U(F_REALM,"Realm:"));
    /* remote server[:port] */
    SSTRING rsdata,
            portdata; // this one is optional
    SSTRING rsportdata; // both together
    gimme_word_from_string(given_vitems.getitem(which_one)->line.get(), rsportdata, 1);
    gimme_word_from_string_bchar(rsportdata.get(), rsdata, 0, ':');
    gimme_word_from_string_bchar(rsportdata.get(), portdata, 1, ':');
    FIELD_COMBO *fc_rsdata;
    fc_rsdata=my_dialog.newf_combo(MSG_U(F_REMOTESERVER,"Remote server:"), rsdata);
    fc_rsdata->addopt("LOCAL");
    my_dialog.newf_str(MSG_U(F_SERVERPORT,"Server port (opt.):"), portdata);
    /* options (unfinished) */
    SSTRING flagdata;
    gimme_word_from_string(given_vitems.getitem(which_one)->line.get(), flagdata, 2, 1);
    EASY_FLAG(hintsflag,"hints",MSG_U(F_DONOTSTRIPATREALM,"do not strip @realm from the username"));
    EASY_FLAG(nostripflag,"nostrip",MSG_U(F_USEUSERNAMEASAFT,"use username as after \"hints\" processing"));

    while(1){
        /* opens dialog.. */
        dialog_title.setfromf(MSG_U(T_REALMENTRYN,"Realm entry %d"), which_one+1);
        my_selection=0;
        my_button=my_dialog.editmenu(dialog_title.get(), "", hf_realms, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ACCEPT:
            {
                /* save vars.. */
                SSTRING my_line;

                if((invalid_entry(realmdata.get()))||(invalid_entry(rsdata.get()))){
                    // this string is unique
                    informative_window(MSG_U(T_INVALIDENTRY2,"Invalid entry"), MSG_U(E_INVALIDENTRY2,"None of these two upper fields may be left empty\nneither have space characters."));
                }else{
                    /* joins rsdata with portdata into rsportdata */
                    rsportdata.setfrom(rsdata.get());
                    if(!invalid_entry(portdata.get()))
                        rsportdata.appendf(":%s", portdata.get());

                    /* builds flags' field */
                    EASY_FLAG_WRITE(hintsflag,"hints");
                    EASY_FLAG_WRITE(nostripflag,"nostrip");

                    my_line.setfromf("%s\t%s\t%s", realmdata.get(), rsportdata.get(), flagdata.get());
                    given_vitems.getitem(which_one)->line.setfrom(my_line);
                    given_vitems.write(cf_realms, 0);
                    return;
                }
            }
            break;
        case MENU_DEL:
            /* remove this entry */
            given_vitems.remove_del(which_one);
            given_vitems.write(cf_realms, 0);
            return;
            break;
        default:
            break;
        }
    }

}

void show_realms_list(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    VIEWITEMS_PARSER my_vitems_parser;
    VIEWITEMS my_vitems(my_vitems_parser);

    my_vitems.read(cf_realms);

    my_dialog.newf_head("", MSG_U(F_REALMREMSERVERHEAD,"realm\tremote server"));

    while(1){
        int         progressive_counter=0,
                    regressive_counter;
        SSTRING     primary_entry,
                    secondary_entry;

        /* fills list.. */
        regressive_counter=my_vitems.getnb();
        while(regressive_counter--){
            gimme_word_from_string(my_vitems.getitem(progressive_counter)->line.get(), primary_entry, 0);
            gimme_word_from_string(my_vitems.getitem(progressive_counter)->line.get(), secondary_entry, 1);
            my_dialog.set_menuitem(progressive_counter, primary_entry.get(), secondary_entry.get());
            progressive_counter++;
        }

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(progressive_counter+1);

        my_button=my_dialog.editmenu(MSG_U(T_REALMS,"Realms"), MSG_U(I_REALMS,"When a user logs in with @realm as\nthe last part of the loginname,\nthe realm part is looked up in this file.\nIf found, the request is sent to\nthe listed remote radius server."), hf_general_list, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                int how_many;

                how_many=my_vitems.getnb();
                my_vitems.add(new VIEWITEM(MSG_U(X_DEFINEME_RADIUSDEFINEME,"define.me\tradius.define.me")));
                edit_realms_entry(my_vitems, how_many);
                my_vitems.write(cf_realms, 0);
            }
            break;
        default:
            edit_realms_entry(my_vitems, my_selection);
            break;
        }
    }


}

