#include <string.h>
#include <time.h>
#include "redhat.h"
#include <limits.h>
#include <userconf.h>
#include "../../userconf/internal.h"
#include <netconf.h>
#include "redhat.m"

int reduser_del(USER *usr, SHADOW *)
{
	return netconf_system_if ("userdel",usr->getname());
}

static int reduser_addmod (
	USER *usr,
	const char *oldname,
	const char *newname,
	SHADOW *shadow,
	const char *command,
	const char *options)
{
	char tmp[PATH_MAX];
	const char *pt = usr->getaltgrs();
	char word[strlen(pt)+1];
	SSTRING altgr;
	while (1){
		pt=str_copyword(word,pt);
		if (word[0] == '\0') break;
		if (!altgr.is_empty()) altgr.append (",");
		altgr.append (word);
	}
	char gecos_esc[1000];
	usr->getgecos_esc (gecos_esc,sizeof(gecos_esc)-1);			
	int len = snprintf (tmp,sizeof(tmp)-1
		,"%s -c %s -d %s -s '%s' -G '%s'"
		,options
		,gecos_esc
		,usr->gethome()
		,usr->getshell()
		,altgr.get());
	if (usr->getuid()!=-1){
		len += sprintf (tmp+len," -u %d",usr->getuid());
	}
	if (usr->getgid()!=-1){
		sprintf (tmp+len," -g %d",usr->getgid());
	}
	if (shadow != NULL){
		int disable = shadow->getdisable();
		bool active;
		if (usr->statuschanged(active)){
			time_t tim = time(NULL);
			int days = tim/(24*60*60);
			if (!active){
				net_prtlog (NETLOG_VERB,MSG_U(I_DISABLED
					,"The account was disabled\n"));
				disable = days - 1;
			}else{
				// The account was locked, it must be enabled again
				if (disable > 0 && disable < days){
					net_prtlog (NETLOG_VERB,MSG_U(I_ENABLED
						,"The account was enabled\n"));
					disable = -1;
				}
			}
		}
		if (disable > 0){
			time_t tim = disable*24*60*60+1;
			char buf[100];
			strftime (buf,sizeof(buf)-1,"%m/%d/%Y",gmtime(&tim));
			strcat (tmp," -e ");
			strcat (tmp,buf);
		}else{
			strcat (tmp," -e ''");
		}
		int expire = shadow->getexpire();
		if (expire != -1){
			strcat (tmp," -f ");
			char buf[20];
			sprintf (buf,"%d",expire);
			strcat (tmp,buf);
		}
	}
	strcat (tmp," ");
	strcat (tmp,oldname);
	int ret = netconf_system_if (command,tmp);
	if (ret != -1 && shadow != NULL){
		sprintf (tmp,"-m %d -M %d -W %d %s",shadow->getmaychange()
			,shadow->getmustchange(),shadow->getwarn()
			,newname);
		ret = netconf_system_if ("chage",tmp);
	}
	netconf_closepipes();
	return ret;
}

int reduser_add (USER *usr, SHADOW *shadow, bool createdir)
{
	const char *name = usr->getname();
	return reduser_addmod (usr,name,name,shadow,"useradd",createdir ? "-m" : "-M");
}

int reduser_change (USER *usr, SHADOW *shadow)
{
	SSTRING opt;
	const char *newname = usr->getname();
	opt.setfromf ("-l %s",newname);
	return reduser_addmod (usr,usr->getoldname(),newname,shadow
		,"usermod",opt.get());
}

