/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "redhatppp.h"
#include "redhatppp.m"
#include "../module_apis/fwinfo_api.h"

MODULE_DEFINE_VERSION(redhatppp);

PUBLIC MODULE_redhatppp::MODULE_redhatppp()
	: LINUXCONF_MODULE("redhatppp")
{
	linuxconf_loadmsg ("redhatppp",PACKAGE_REV);
	module_register_api ("fwinfo",FWINFO_API_REV,redhatppp_fwinfo_api_get
		,redhatppp_fwinfo_api_release);
}

static const char *keymenu=NULL;
static const char *ppplink=NULL;

PUBLIC void MODULE_redhatppp::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_CLIENT){
		keymenu = MSG_U(M_dialout,"PPP/SLIP/PLIP");
		dia.new_menuitem ("redhatppp","",keymenu);
	}else if (context == MENU_CONTROL_PANEL){
		ppplink = MSG_U(M_PPPCTRL,"Control PPP/SLIP/PLIP links");
		dia.new_menuitem ("",ppplink);
	}
}

PUBLIC int MODULE_redhatppp::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_CLIENT){
		if (key == keymenu){
			ppprh_edit();
		}
	}else if (context == MENU_CONTROL_PANEL){
		if (key == ppplink){
			ppprh_control();
		}
	}
	return 0;
}

PUBLIC int MODULE_redhatppp::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"redhatppp")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module redhatppp\n"
		 "linuxconf --modulemain redhatppp\n"
		 "\n"
		 "    No command line option\n"
		 "\n")
		);
}

PUBLIC int MODULE_redhatppp::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"redhatppp")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_redhatppp redhatppp;

