#!/bin/sh
if [ $# != 3 ] ; then
	echo buildspec.sh 1.9r26.15 version_rpm rpm_topdir
	echo normaly used with
	echo "  " make RPMREV=1 buildrpm
	exit 1
elif [ ! -d rpmfiles ] ; then
	echo buildspec.sh must be executed from the top directory
	echo of the linuxconf source distribution
	exit 1
else
	if [ -d $3/SPECS ] ; then
		OUT=$3/SPECS/linuxconf-$1.spec
	elif [ -d /usr/src/packages/SPECS ] ; then
		OUT=/usr/src/packages/SPECS/linuxconf-$1.spec
	else
		echo No SPECS directory found, can\'t build rpm spec file
		exit 1
	fi
	MODULEREV=`grep MODULE_API_VERSION misc/module.h | ( read a b c && echo $c )`
	echo Generating $OUT
	sed s/PACKAGEREV/$1/ <rpmfiles/rpm.spec-intro \
		| sed s/RPMREV/$2/ \
		| sed s/LINUXCONFAPIREV/LINUXCONFAPIREV$MODULEREV/ >$OUT
	for f in desc gui lib lang devel util prep build install clean pre post preun postun files
	do
		sed s/PACKAGEREV/$1/ <rpmfiles/rpm.spec-$f >>$OUT
		# Append the localised version of this file if exist
		# Note that this breaks RPM on some distro (SuSE)
		# so for now, this is disabled
		#for lang in sk fr it de pt
		#do
		#	FILELANG=rpmfiles/rpm.spec-$f.$lang
		#	if [ -f $FILELANG ] ; then
		#		sed s/PACKAGEREV/$1/ <$FILELANG >>$OUT
		#	fi
		#done
	done
fi

