#include <stdio.h>
#include <string.h>
#include "xconf.h"
#include "components.h"

/*
	A notice is simply a table of string. It generally hold a message
	to display to the user when a selection is made.
*/
PUBLIC NOTICE::NOTICE ()
{
	tbstr = NULL;
	nbstr = 0;
	maxstr = 0;
}
PUBLIC NOTICE::~NOTICE ()
{
	for (int i=0; i<nbstr; i++) free (tbstr[i]);
	free (tbstr);
}
PUBLIC void NOTICE::add (const char *str)
{
	if (maxstr == nbstr){
		maxstr += 10;
		tbstr = (char**)realloc (tbstr,maxstr*sizeof(char*));
	}
	tbstr[nbstr++] = strdup(str);
}

PUBLIC int NOTICE::print(FILE *fout, int indent) const
{
	for (int i=0; i<nbstr; i++){
		for (int n=0; n<indent; n++) fputc ('\t',fout);
		fprintf (fout,"%s\n",tbstr[i]);
	}
	return 0;
}
/*
	Place all the strings of a notice in a single one.
	Return -1 if the maximum size of the buf is exceeded.
*/
PUBLIC int NOTICE::format(char *buf, int maxsiz) const
{
	int ret = 0;
	char *pt = buf;
	for (int i=0; i<nbstr; i++){
		char *str = tbstr[i];
		int len = strlen(str);
		if ((pt-buf)+len+1 >= maxsiz){
			ret = -1;
			break;
		}else{
			strcpy (pt,str);
			pt += len;
			*pt++ = '\n';
		}
	}
	*pt = '\0';
	return ret;
}

