#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif

#ifndef DIALOG_H
	#include "dialog.h"
#endif


class BUTTONS_INFO {
	int but_options;	// Set of MENUBUT_xxxx
	int nb;
	const char *tb_title[10];
	const char *tb_icon[10];
	MENU_STATUS tbret[10];	// Return code associated with a button
	struct BCOOR{
		int x;		// Horizontal coordinate of each buttons
		int y;		// Vertical
	}tbcoor[10];
	SSTRING helpfile;	/* File to show when help is selected */
	struct {
		short int id;
		SSTRING title;
		SSTRING icon;
	}tbusr[10];
	int nbusr;
	HELP_FILE **tbhelp;		// Auxiliary help files
	int nbhelp;
	int maxhelp;
	SSTRINGS tbhelpt;		// Titles of the auxiliary help screens
	bool ismainmenu;		// This dialog is the main menu
	/*~PROTOBEG~ BUTTONS_INFO */
public:
	BUTTONS_INFO (void);
	void addhelp (HELP_FILE&help, const char *title);
	MENU_STATUS bid2status (int id);
	void delbutinfo (void);
	MENU_STATUS dokey (WINDOW *dialog,
		 int key,
		 int &selected,
		 int other_focus);
	void draw (WINDOW *dialog, int button);
	int evalwidth (void);
	void gui_draw (bool onside);
	void help (WINDOW *win);
	void html_draw (void);
	void set (int _but_options, HELP_FILE&_helpfile);
	void setbutinfo (int id,
		 const char *title,
		 const char *icon);
	void setcursor (WINDOW *dialog, int button);
	void setup (int _y, int width);
	~BUTTONS_INFO (void);
	/*~PROTOEND~ BUTTONS_INFO */
};

class HTML_VARVAL{
	SSTRINGS vars;
	SSTRINGS vals;
	SSTRING context;
	int id;
	/*~PROTOBEG~ HTML_VARVAL */
public:
	HTML_VARVAL (const char *key);
	void add (const char *var, const char *val);
	int exist (const char *var);
	const char *getcontext (void);
	int getid (void);
	int getnb (void);
	const char *getval (const char *var, int &exist);
	const char *getval (int no);
	const char *getvar (int no);
	/*~PROTOEND~ HTML_VARVAL */
};

class FIELD_MENU: public FIELD_STRING{
	friend	class DIALOG;
	friend	class DIALOG_LISTE;
	friend	class DIALOG_RECORDS;
	friend	class DIALOG_MENU;
	int tbcol[DIALOG_MAXCOL];	// Width of each columns
	char *tag;
	char *icon;	// Xpm icon file or NULL
	enum HTML_KEY_TYPE key_type; // see FIELD_MENU::format_htmlkey()
	/*~PROTOBEG~ FIELD_MENU */
public:
	FIELD_MENU (const char *_icon,
		 const char *_tag,
		 const char *_str);
protected:
	MENU_STATUS dokey (WINDOW *,
		 int ,
		 FIELD_MSG&,
		 bool&);
public:
	void drawgen (WINDOW *win,
		 bool selected,
		 int offset);
	void drawtxt (WINDOW *dialog, int offset);
	void format_htmlkey (char *key, int no);
	char getidprefix (void);
	const char *getmenuicon (void)const;
	const char *getmenustr (void)const;
protected:
	int getwidths (int tb[], int &);
public:
	void gui_draw (int nof, SSTRINGS&);
	void html_draw (int nof);
	int html_validate (int);
	void popup_draw (int id, int &);
protected:
	void restore (void);
	void save (void);
public:
	void setcursor (WINDOW *dialog, int offset);
	void setwidths (int total_width, int tb[]);
	void unselect (WINDOW *dialog, int offset);
	~FIELD_MENU (void);
	/*~PROTOEND~ FIELD_MENU */
};

class DIALOG_INTERNAL{
public:
	BUTTONS_INFO *buttons;
	int button;	// Button currently selected or -1
	int selected_button;	// Button selected by the application before
							// calling edit
	int width;
	int height;
	int button_height;		// Height allocated to buttons, generally
							// 3 lines.
	SSTRING title;
	SSTRING sidetitle;
	SSTRING intro;
	SSTRING last_intro;
	SSTRING icon;
	int offset;	// Number of the first visible field
	int nbvisible;	// How many field are visible (window height)
	struct {
		SSTRING save;
		SSTRING ins;
		SSTRING add;
		SSTRING del;
	}what;	// Small explanation about the behavior of some special
		// buttons.
	struct {
		SSTRING top;
		SSTRING intro;
		SSTRING body;
		SSTRING end;
	}html_bypass;
	SSTRING internal_title;
	bool guidone;
	bool guidone_once;
	int gui_id;			// Unique ID assigned to dialogs
	int thread_id;		// uithread_id at dialog creation time
	bool all_protected;
	bool autonewline;
	// Specific to FIELD_MENU
	int treelevel;
	int last_visited;	// Last field visited
	// Specific to DIALOG_LISTE
	DIALOG_RECORDS *subdia;
	int *lookup;
	int nblookup;
	bool height_hint;
	HTML_KEY_TYPE key_type;
	SSTRINGS waitmsg;	// This dialog is waiting for some messages
						// send using dialog_sendmessage()
	PRIVATE_MESSAGES waitprivmsg;
	DIALOG_TYPE diatype;
	WINDOW *cursw;
	bool context_wasset;
	SSTRING context;
	bool button_on_side;
	int hoffset;		// Horizontal scroll
	const char *registry_id;	// String uniquely identifying this dialog
								// Used when a field is a member of several
								// dialog (a field prompt), so the virtual
								// registry can differentiate which dialog
								// is targetted. Generally left NULL
	int last_nof;		// Last current field known to the GUI
	bool listening;		// Is this dialog currently listening
						// or is it waiting for another dialog to get back
	bool gui_listen;	// What does the GUI knows about this dialog
						// should we sent a Listen directive for this dialog
						// or the GUI already knows about it.
	SSTRING guiparms;
	int insert_pos;		// Insertion position of the next field or -1
						// if it is simply add to the end
};

#define DIAFLAGS_AUTONEWLINE	1
#define DIAFLAGS_NOAUTONEWLINE	2

extern int treemenu_pos[20];		// Assume maximum 20 levels of menu

#endif

