#!/bin/sh
# Install a binary dictionnary in /usr/lib/linuxconf
if [ $# != 1 ] ; then
	echo
	echo You must specify the langage id "(subdirectory in message)"
	echo
elif [ ! -f installmsg.sh ] ; then
	echo
	echo The current directory must be messages
	echo
elif [ ! -d $1 ] ; then
	echo
	echo The langage is not initialised yet
	echo
elif [ "$PACKAGE_REV" = "" ] ; then
	make LANG=$1 install-one-lang
else
	echo Installing messages for `cat $1/lang.title`
	LIB_LINUXCONF=$RPM_BUILD_ROOT/usr/lib/linuxconf/
	export LANG=$1
	make LANG=$1 msg.$1 >/dev/null
	for mod in `./module_getlist.sh`
	do
		echo "    Module $mod"
		../translate/msgcomp -psources/ \
			-p$LANG/ \
			$LIB_LINUXCONF/help.$LANG/$mod-msg-$PACKAGE_REV.$LANG TE \
			$mod >/dev/null
		#make -s LANG=$1 MODULEDIC=$mod msgmod.$1
	done
	rm -f $RPM_BUILD_ROOT/var/run/treemenu.cache
fi



