#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static PyObject *
lcregistry_start_session(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	master_registry.start_session();
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
lcregistry_end_session(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	master_registry.end_session();
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
lcregistry_get(PyObject *self, PyObject *args)
{
	char *key;
	const char *value;
	if (!PyArg_ParseTuple(args,"s", &key))
		return NULL;
	value = master_registry.get(key);
	if (value == NULL) {
		PyErr_SetString(PyExc_KeyError, "key not found");
		return NULL;
	}
	return PyString_FromString(value);
}

static PyObject *
lcregistry_set(PyObject *self, PyObject *args)
{
	char *key;
	char *value;
	if (!PyArg_ParseTuple(args,"ss", &key, &value))
		return NULL;
	if (master_registry.set(key, value) == -1) {
		PyErr_SetString(PyExc_KeyError, "key not found");
		return NULL;
	}
	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef lcregistry_methods[] = {
	{"start_session", lcregistry_start_session, 1},
	{"end_session", lcregistry_end_session, 1},
	{"get", lcregistry_get, 1},
	{"set", lcregistry_set, 1},
	{NULL, NULL}
};

extern "C" void
initlcregistry()
{
	PyObject *m, *d;
	m = Py_InitModule("lcregistry", lcregistry_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcregistry.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcregistry");
}
