
#include "report.h"
#include "report.m"

void report_create(SSTRINGS &report, const char superprobe)
{
	reports_add_header(report, "comment", "");
	reports_add_string(report, "Report created by Linxconf");
	reports_add_string(report, "The report module was written by Gustavo Niemeyer <niemeyer@conectiva.com>");
	reports_add_string(report, "Copyright (c) 2000, Conectiva, Inc");
	reports_add_file(report, "/proc/version");
	reports_add_file(report, "/proc/cpuinfo");
	reports_add_file(report, "/proc/meminfo");
	reports_add_file(report, "/proc/rtc");
	reports_add_file(report, "/proc/devices");
	reports_add_file(report, "/proc/ioports");
	reports_add_file(report, "/proc/dma");
	reports_add_file(report, "/proc/pci");
	reports_add_file(report, "/proc/modules");
	reports_add_file(report, "/proc/partitions");
	reports_add_file(report, "/proc/mounts");
	reports_add_file(report, "/proc/swaps");
	reports_add_file(report, "/proc/interrupts");
	reports_add_file(report, "/proc/sound");
	reports_add_file(report, "/etc/printcap");
	reports_add_file(report, "/etc/fstab");
	reports_add_file(report, "/proc/ide/hda/model");
	reports_add_file(report, "/proc/ide/hda/geometry");
	reports_add_file(report, "/proc/ide/hda/driver");
	reports_add_file(report, "/proc/ide/hda/settings");
	reports_add_file(report, "/proc/ide/hdb/model");
	reports_add_file(report, "/proc/ide/hdb/geometry");
	reports_add_file(report, "/proc/ide/hdb/driver");
	reports_add_file(report, "/proc/ide/hdb/settings");
	reports_add_file(report, "/proc/ide/hdc/model");
	reports_add_file(report, "/proc/ide/hdc/geometry");
	reports_add_file(report, "/proc/ide/hdc/driver");
	reports_add_file(report, "/proc/ide/hdc/settings");
	reports_add_file(report, "/proc/ide/hdd/model");
	reports_add_file(report, "/proc/ide/hdd/geometry");
	reports_add_file(report, "/proc/ide/hdd/driver");
	reports_add_file(report, "/proc/ide/hdd/settings");
	reports_add_file(report, "/proc/tty/driver/serial");
	reports_add_file(report, "/proc/tty/drivers");
	reports_add_file(report, "/etc/inittab");
	reports_add_command(report, "ifconfig");
	if (superprobe) {
		// Why it doesn't work without the path??
		reports_add_command(report, "/usr/X11R6/bin/SuperProbe");
	}
	reports_add_command(report, "lspci -v");
	reports_add_command(report, "pnpdump");
}


void report_edit()
{
	DIALOG dia;
	char superprobe = 1;
	dia.newf_chk("", superprobe, MSG_U(T_RUNSUPERPROBE,"Run SuperProbe"));
	char save = 0;
	dia.newf_chk("", save, MSG_U(T_SAVETOFILE,"Save report to file"));
	SSTRING filename = "./report.txt";
	dia.newf_str(MSG_U(I_FILENAME,"Filename"), filename);
	int nof = 0;
	while (1) {
		MENU_STATUS code = dia.edit(MSG_U(T_REPORTS,"Reports"),"",help_nil,nof,MENUBUT_ACCEPT|MENUBUT_CANCEL);
		if (code == MENU_QUIT || code == MENU_ESCAPE || code == MENU_CANCEL) {
			break;
		} else if (code == MENU_ACCEPT) {
			SSTRINGS report;
			report_create(report, superprobe);
			if (save) {
				report_save(report, filename.get());
			}
			report_view(report);
		}
	}
}

void report_view(SSTRINGS &report)
{
	while (1) {
		//MENU_STATUS code = dia.edit("View report","",help_nil,nof,MENUBUT_QUIT);
		MENU_STATUS code = dialog_textbox(MSG_U(T_VIEWREPORT,"View report"), report);
		if (code == MENU_QUIT || code == MENU_ESCAPE || code == MENU_CANCEL) {
			break;
		}
	}
}

void report_save(SSTRINGS &report, const char *filename)
{
	FILE *file = fopen(filename, "w");
	if (file == NULL) {
		xconf_error(MSG_U(E_CANTWRITE,"Can't write on this file!"));
	} else {
		int nb = report.getnb();
		for (int i = 0; i != nb; i++) {
			SSTRING *str = report.getitem(i);
			fwrite(str->get(), 1, str->getlen(), file);
			fputc('\n', file);
		}
		fclose(file);
		xconf_notice(MSG_U(N_SAVED, "Report saved to %s!"), filename);
	}
}

