#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <utmp.h>
#include <sys/vfs.h>
#include "status.m"
#include "../../diajava/proto.h"
#include <dialog.h>
#include <usercomng.h>
#include <netconf.h>
#include <fstab.h>

HELP_FILE help_statuswin ("status","statuswin");


struct STATUSINFO{
	SSTRING	uptime;
	SSTRING load[3];
	SSTRING users;
	int memory;
	int totalmem;
	int swap;
	int totalswap;
	int openfiles;
	int totalopenfiles;
};

static void status_loadinfo (STATUSINFO &inf)
{
	inf.memory = inf.swap = inf.totalmem = inf.totalswap = 0;
	inf.totalopenfiles = inf.openfiles = 0;
	inf.uptime.setfrom ("");
	inf.load[0].setfrom ("");
	inf.load[1].setfrom ("");
	inf.load[2].setfrom ("");
	inf.users.setfrom ("");
	FILE *fin = fopen ("/proc/meminfo","r");
	if (fin != NULL){
		char buf[1000];
		int buffers = 0;
		int cached = 0;
		while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			if (strncmp(buf,"MemTotal:",9)==0){
				inf.totalmem = atoi(str_skip(buf+9));
			}else if (strncmp(buf,"MemFree:",8)==0){
				inf.memory = atoi(str_skip(buf+8));
			}else if (strncmp(buf,"SwapTotal:",10)==0){
				inf.totalswap = atoi(str_skip(buf+10));
			}else if (strncmp(buf,"SwapFree:",9)==0){
				inf.swap = atoi(str_skip(buf+9));
			}else if (strncmp(buf,"Cached:",7)==0){
				cached = atoi(str_skip(buf+7));
			}else if (strncmp(buf,"Buffers:",8)==0){
				buffers = atoi(str_skip(buf+8));
			}
		}
		inf.memory += cached + buffers;
		inf.memory = (int)(((inf.totalmem-inf.memory)/(double)inf.totalmem)*100);
		inf.swap   = (int)(((inf.totalswap-inf.swap)/(double)inf.totalswap)*100);
		inf.totalmem /= 1000;
		inf.totalswap /= 1000;
		fclose (fin);
	}
	fin = fopen ("/proc/loadavg","r");
	if (fin != NULL){
		char buf[1000];
		if (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			char *pt = inf.load[0].copyword(buf);
			pt = inf.load[1].copyword(pt);
			inf.load[2].copyword(pt);
		}
		fclose (fin);
	}
	fin = fopen ("/proc/uptime","r");
	if (fin != NULL){
		char buf[1000];
		if (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			int up = atoi(buf);
			int days = up / (24*60*60);
			int rest = up % (24*60*60);
			int hours = rest/( 60*60);
			rest = rest % ( 60*60);
			int mins = rest/60;
			inf.uptime.setfromf (MSG_U(I_UPTIME,"%d days %d hours %d minutes")
				,days,hours,mins);
		}
		fclose (fin);
	}
	fin = fopen ("/proc/sys/fs/file-nr","r");
	if (fin != NULL){
		char buf[1000];
		if (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			int sizetbl;	// Size of the current kernel file table
			int freeent;	// Free entries in this table
			sscanf (buf,"%d %d %d",&sizetbl,&freeent,&inf.totalopenfiles);
			inf.openfiles = (sizetbl - freeent) * 100 / inf.totalopenfiles;
		}
		fclose (fin);
	}
	setutent();
	struct utmp *u;
	int nbuser = 0;
	while ((u=getutent())!=NULL){
		if (u->ut_type == USER_PROCESS) nbuser++;
	}
	endutent();
	inf.users.setfromf("%d",nbuser);
}

static int status_initfs(SSTRINGS &tbfs)
{
	FSTAB fstab;
	// We show all local file systems, except supermount stuff
	// because any statistic done on a supermount fs trigger a mount
	// which is annoying.
	for (int i=0; i<fstab.getnb(); i++){
		FSTAB_ENTRY *en = fstab.getitem(i);
		if (en->is_valid()
			&& en->is_auto()
			&& en->gettype() == FSTAB_ENTRY_LOCAL
			&& strcmp(en->getfs(),"supermount")!=0){
			const char *mpt = en->getmpoint();
			if (strcmp(mpt,"/boot")!=0){
				tbfs.add (new SSTRING(mpt));
			}
		}
	}
	return tbfs.getnb();
}

static void status_loadfs(SSTRINGS &tbfs, int tbusage[], int tbsize[])
{
	for (int i=0; i<tbfs.getnb(); i++){
		struct statfs st;
		int usage = 0;
		int size = 0;
		if (statfs(tbfs.getitem(i)->get(),&st)!=-1
			&& st.f_blocks > 0){
			usage = (st.f_blocks - st.f_bavail) * 100 / st.f_blocks;
			if (st.f_bsize == 512){
				size = st.f_blocks / 2048;
			}else{
				size = st.f_blocks * (st.f_bsize/1024) / 1024;
			}
		}
		tbusage[i] = usage;
		tbsize[i] = size;
	}
}

static const char K_STATUS[]="status";
static const char K_ICONXPM[]="iconxpm";
static const char K_AUTOMON[]="automon";
static bool status_running = false;

static void status_fct (void *p)
{
	status_running = true;
	const char *ctx = (const char *)p;
	char icon[100];
	diagui_sendxpm (linuxconf_getval(K_STATUS,K_ICONXPM,"linuxconf.xpm")
		,icon);
	DIALOG dia;
	dia.setcontext (ctx);
	static const char *dcstatus = NULL, *dcwhite = NULL;
	if (dcstatus == NULL){
		const char *fontstatus = guiid_setfont (24,GFONT_ID_MODERN,GFONT_STYLE_DEFAULT,GFONT_WEIGHT_BOLD,false);
		const char *penstatus  = guiid_setpen ("blue");
		const char *brushstatus = guiid_setbrush ("blue");
		dcstatus = guiid_setdc (fontstatus,penstatus,brushstatus);
		const char *penwhite = guiid_setpen ("white",0,GPEN_STYLE_SOLID);
		const char *brushwhite  = guiid_setbrush ("white");
		dcwhite = guiid_setdc (NULL,penwhite,brushwhite);
	}
	dia.gui_passthrough (P_Form,"\"%s\" $hexpand=0\n",MSG_U(T_STATUSWIN,"Status"));
	THISHOST hs;
	dia.gui_passthrough (P_Clear,"$dc=%s\n",dcwhite);
	dia.gui_passthrough (P_Label,"\"%s\" $dc=%s\n",hs.getname1(),dcstatus);
	dia.gui_passthrough (P_Dispolast,"c 1 c 1\n");
	dia.gui_passthrough (P_Newline,"\n");
	dia.gui_passthrough (P_Label,"\"(%s %s)\"\n",MSG_U(I_PROFILE,"Profile")
		,confver_getcur());
	dia.gui_passthrough (P_Dispolast,"c 1 c 1\n");
	dia.gui_passthrough (P_Newline,"\n");
	dia.gui_passthrough (P_Icon_xpm,"%s\n",icon);
	dia.gui_passthrough (P_Dispolast,"c 1 c 1\n");
	dia.gui_passthrough (P_Newline,"\n");
	dia.gui_passthrough (P_End,"\n");
	dia.gui_passthrough (P_Dispolast,"c 10 c 1\n");
	dia.gui_passthrough (P_Newline,"\n");
	dia.gui_passthrough (P_Clear,"$dc=%s\n",dcwhite);

	#if 0
	dia.gui_passthrough (P_Drawline,"0 0 1000 1000 $dc=%s\n",dcstatus);
	dia.gui_passthrough (P_Drawrect,"10 1 30 30 $dc=%s\n",dcstatus);
	dia.gui_passthrough (P_Fillrect,"10 40 30 70 $dc=%s\n",dcstatus);
	dia.gui_passthrough (P_Drawarc,"50 100 200 100 100 150 $dc=%s\n",dcstatus);
	#endif
	STATUSINFO inf;
	status_loadinfo (inf);
	dia.newf_str (MSG_U(F_UPTIME,"Up time"),inf.uptime);
	dia.set_lastreadonly();
	dia.gui_passthrough (P_Dispolast,"l 10 c 1\n");
	dia.gui_passthrough (P_Newline,"\n");
	dia.newf_str (MSG_U(F_LOADAVG,"Load average (5 min.)"),inf.load[0],7);
	dia.set_lastreadonly();
	dia.newf_str (MSG_U(F_LOAD10,"10 min."),inf.load[1],7);
	dia.set_lastreadonly();
	dia.newf_str (MSG_U(F_LOAD15,"15 min."),inf.load[2],7);
	dia.set_lastreadonly();
	dia.gui_passthrough (P_Newline,"\n");

	dia.newf_str (MSG_U(F_USERS,"Users"),inf.users,10);
	dia.set_lastreadonly();
	dia.gui_passthrough (P_Dispolast,"l 10 c 1\n");
	dia.gui_passthrough (P_Newline,"\n");


	char range[100];
	dia.newf_gauge (MSG_U(F_MEMORY,"Memory used"),inf.memory,100);
	dia.gui_passthrough (P_Dispolast,"l 4 c 1\n");
	snprintf (range,sizeof(range)-1, MSG_U(I_RANGEMEGS,"%d megs"),inf.totalmem);
	dia.gui_passthrough (P_Label,"\"%s\"\n",range);
	dia.gui_passthrough (P_Newline,"\n");

	dia.newf_gauge (MSG_U(F_SWAP,"Swap used"),inf.swap,100);
	dia.gui_passthrough (P_Dispolast,"l 4 c 1\n");
	snprintf (range,sizeof(range)-1, MSG_R(I_RANGEMEGS),inf.totalswap);
	dia.gui_passthrough (P_Label,"\"%s\"\n",range);
	dia.gui_passthrough (P_Newline,"\n");

	dia.newf_gauge (MSG_U(F_OPENFILES,"Open files"),inf.openfiles,100);
	dia.gui_passthrough (P_Dispolast,"l 4 c 1\n");
	snprintf (range,sizeof(range)-1, MSG_U(I_OPENFILES,"max %d"),inf.totalopenfiles);
	dia.gui_passthrough (P_Label,"\"%s\"\n",range);
	dia.gui_passthrough (P_Newline,"\n");

	SSTRINGS tbfs;
	int nbfs = status_initfs (tbfs);
	int tbusage[nbfs],tbsize[nbfs];
	status_loadfs(tbfs,tbusage,tbsize);
	for (int i=0; i<nbfs; i++){
		dia.newf_gauge (tbfs.getitem(i)->get(),tbusage[i],100);
		dia.gui_passthrough (P_Dispolast,"l 4 c 1\n");
		snprintf (range,sizeof(range)-1,MSG_R(I_RANGEMEGS),tbsize[i]);
		dia.gui_passthrough (P_Label,"\"%s\"\n",range);
		dia.gui_passthrough (P_Newline,"\n");
	}
	
	int nof = 0;
	PRIVATE_MESSAGE t3;
	dialog_settimer (t3,3,true);
	dia.waitfortimer (t3);
	while (1){
		MENU_STATUS code = dia.edit (MSG_R(T_STATUSWIN)
			,"",help_nil,nof,MENUBUT_CANCEL);
		if (code == MENU_CANCEL){
			break;
		}else if (code == MENU_MESSAGE){
			if (dialog_testtimer (t3)){
				// This is the timer
				status_loadinfo (inf);
				status_loadfs (tbfs,tbusage,tbsize);
				dia.reload();
			}
		}
	}
	status_running = false;
}	

int status_win(const char *guictx, bool force)
{
	int ret = -1;
	if (force || linuxconf_getvalnum (K_STATUS,K_AUTOMON,1)!=0){
		if (!status_running){
			uithread (status_fct,(void*)guictx);
		}
		ret = 0;
	}
	return ret;
}

class STATUS_COMNG: public USERACCT_COMNG{
	SSTRING icon;
	char automon;
	int field;
	/*~PROTOBEG~ STATUS_COMNG */
public:
	STATUS_COMNG (DICTIONARY&_dict);
	int save (PRIVILEGE *priv);
	void setupdia (DIALOG&dia);
	int validate (DIALOG&, int &nof);
	/*~PROTOEND~ STATUS_COMNG */
};


PUBLIC STATUS_COMNG::STATUS_COMNG(
	DICTIONARY &_dict)
	: USERACCT_COMNG (_dict)
{
	icon.setfrom (linuxconf_getval(K_STATUS,K_ICONXPM,"linuxconf.xpm"));
	automon = linuxconf_getvalnum (K_STATUS,K_AUTOMON,1);
}

PUBLIC void STATUS_COMNG::setupdia (
	DIALOG &dia)
{
	dia.newf_title (MSG_U(T_MODSTATUS,"Module status"),1,"",MSG_R(T_MODSTATUS));
	dia.newf_chk ("",automon,MSG_U(I_AUTOMON,"Enable the monitor window"));
	field = dia.getnb();
	FIELD_COMBO *comb = dia.newf_combo (MSG_U(F_ICONXPM,"Xpm icon"),icon);
	comb->addopt ("dns");
	comb->addopt ("linuxconf");
	comb->addopt ("users");
	dia.addhelp (help_statuswin,MSG_R(T_MODSTATUS));
}	

PUBLIC int STATUS_COMNG::save(
	PRIVILEGE *priv)
{
	linuxconf_replace (K_STATUS,K_ICONXPM,icon);
	linuxconf_replace (K_STATUS,K_AUTOMON,automon);
	return 0;
}


PUBLIC int STATUS_COMNG::validate(
	DIALOG &,
	int &nof)
{
	return 0;
}

static USERACCT_COMNG *STATUS_newcomng(
	const char *key,
	DICTIONARY &dict)
{
	USERACCT_COMNG *ret = NULL;
	if (strcmp(key,"features")==0){
		ret = new STATUS_COMNG (dict);
	}
	return ret;
}

static REGISTER_USERACCT_COMNG ppp (STATUS_newcomng);

