#ifndef syslogconf_h
#define syslogconf_h
#pragma interface
#ifndef MISC_H
    #include <misc.h>
#endif
#ifndef MODULE_H
    #include <module.h>
#endif

#include <modapi_def.h>
#include <modapi.h>
class MODULE_syslogconf: public LINUXCONF_MODULE{
    /*~PROTOBEG~ MODULE_syslogconf */
public:
	MODULE_syslogconf (void);
	int dohtml (const char *key);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc,
		 char *argv[],
		 bool);
	int message (const char *msg,
		 int argc,
		 const char *argv[]);
	void setmenu (DIALOG&dia,
		 MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
    /*~PROTOEND~ MODULE_syslogconf */
};

#include <fviews.h>

class SYSLOG_FILE: public ARRAY_OBJ{
public:
	VIEWITEM *item;
	SSTRING path;
	char issync;
	SSTRING selections;
    /*~PROTOBEG~ SYSLOG_FILE */
public:
	SYSLOG_FILE (VIEWITEM *_item);
	SYSLOG_FILE (void);
	int edit (void);
	void format (VIEWITEMS&items);
	bool is_file (void)const;
    /*~PROTOEND~ SYSLOG_FILE */
};

class SYSLOGCONF: public ARRAY{
public:
	VIEWITEMS items;
    /*~PROTOBEG~ SYSLOGCONF */
public:
	SYSLOGCONF (void);
	int edit (void);
	void execmenu (int no);
	SYSLOG_FILE *getitem (int no)const;
	void setmenubar (void);
	void sort (void);
	int write (void);
    /*~PROTOEND~ SYSLOGCONF */
};

class VIEWLOG_API;
class PRIVILEGE;

#include "syslogconf.p"

#endif
