#include <string.h>
#include <stdlib.h>
#include "xconf.h"
#include "section.h"



/*
	Make a copy of itself
*/
PUBLIC VIRTUAL SECTION *SECTION::clone() const
{
	SECTION *ret = new SECTION (name);
	if (ret != NULL){
		for (int i=0; i<getnb(); i++){
			ret->add (getitem(i)->clone());
		}
	}
	return ret;
}


#if 0
/*
	Add/merge a SECTION into another
	Section and their content are added to the destination
*/
PUBLIC void SECTION::merge (const SECTION *src)
{
	OPTION::merge (src);
	OPTION **tbsrc = src->tbvalues;
	int nbsrc = src->nbvalues;
	OPTION **tbdst = tbvalues;
	int nbdst = nbvalues;
	for (int i=0; i<nbsrc; i++){
		const OPTION *optsrc = tbsrc[i];
		for (int j=0; j<nbdst; j++){
			OPTION *optdst = tbdst[i];
			if (strcmp(optdst->keyw,optsrc->keyw)==0){
				optdst->merge (optsrc);				
				break;
			}
		}
		if (j == nbdst){
			// The section must simply be copied
			addoption (optsrc->clone());
		}
	}
}
#endif

/*
	Locate the value of an item identified with keyw
	Return NULL if not found.
*/
PUBLIC const char *SECTION::findarg (const char *keyw)
{
	const char *ret = NULL;
	for (int i=0; i<getnb(); i++){
		const OPTION *opt = getitem(i);
		if (strcmp(opt->keyw,keyw)==0){
			ret = opt->arg;
			break;
		}
	}
	return ret;
}

