package Lire::Test::CommandResult;

use strict;

=pod

=head1 NAME

Lire::Test::CommandResult - Object used to report the results of shell commands

=head1 SYNOPSIS

  use Lire::Test::FunctionalTestCase;

  my $result = $self->lire_run( "echo Test" );
  print $result->status();
  print $result->stdout();
  print $result->stderr();

  print scalar $result->sent_mail(), " emails were sent.\n";

=head1 DESCRIPTION

Lire::Test::ComandResult objects are used to report the results
of shell commands run through Lire::Test::FunctionalTestCase::lire_run().

=cut

sub new {
    my $class = shift;

    return bless { @_ }, $class;
}

=pod 

=head2 command()

Returns the shell command that was run. This is the complete command line
which was interpreated by the shell.

=cut

sub command {
    return $_[0]{'_command'};
}

=pod 

=head2 status()

Returns the command result status. (What is usually contained in $?).

=cut

sub status {
    return $_[0]{'_status'};
}

=pod 

=head2 stdout()

Returns what was output on stdout while executing the command.

=cut

sub stdout {
    return $_[0]{'_stdout'};
}

=pod 

=head2 stderr()

Returns what was output on stderr while executing the command.

=cut

sub stderr {
    return $_[0]{'_stderr'};
}

=pod

=head2 sent_mail()

Returns in an array reference the message that were sent out during
this command run. The element of this array are hash reference
containing two keys:

=over

=item recipients

An array reference containing the recipients as passed on the command
line to sendmail.

=item message

The email which was sent. This is the complete text of the email. This
is what was passed to sendmail via STDIN.

=back

=cut

sub sent_mail {
    return $_[0]{'_sent_mail'};
}

1;
__END__

=pod

=head1 SEE ALSO

Lire::Test::FunctionaLTestCase(3pm)

=head1 VERSION

$Id: CommandResult.pm,v 1.5 2004/03/31 16:34:22 flacoste Exp $

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2003 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
