#
# Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
#n but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program (see COPYING); if not, check with
# http://www.gnu.org/copyleft/gpl.html or write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
#
# Author: Francis J. Lacoste <flacoste@logreport.org>
package Lire::DlfAnalysers::EmailConcatenater;

use strict;

use base qw/Lire::DlfCategoriser/;

sub new {
    return bless {}, shift;
}

sub name {
    return "email_concat";
}

sub title {
    return "Email Concatenater Analyser";
}

sub description {
    return '<para>This analyser adds the
<structfield>from_email</structfield> and
<structfield>to_email</structfield> fields by
concatenating the <structfield>user</structfield> and <structfield>domain</structfield> fields.
</para>';
}

sub src_schema {
    return "email";
}

sub dst_schema {
    return "email-email";
}

sub initialise {
    my ( $self, $config ) = @_;

    return;
}

sub categorise {
    my ( $self, $dlf ) = @_;

    if ( defined $dlf->{'from_user'} &&
             defined $dlf->{'from_domain'} ) 
    {
        $dlf->{'from_email'} = $dlf->{'from_user'} . '@' .
            $dlf->{'from_domain'};
    }
    
    if ( defined $dlf->{'to_user'} &&
             defined $dlf->{'to_domain'} ) 
    {
        $dlf->{'to_email'} = $dlf->{'to_user'} . '@' .
            $dlf->{'to_domain'};
    }

    return;
}

# keep perl happy
1;

