/**
 * SECTION:dependency
 * @short_description: Definition of a dependency of an application
 * 
 * <para>Contains a #AsComponent which holds the actual information about the referenced component-dependency.</para>
 */
/**
 * LISTALLER_TYPE_DEPENDENCY:
 * 
 * The type for <link linkend="ListallerDependency"><type>ListallerDependency</type></link>.
 */
/**
 * listaller_dependency_load_xml_data:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @xmld: &nbsp;
 * @error: location to store the error occuring, or %NULL to ignore
 */
/**
 * listaller_dependency_load_from_file:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @fname: &nbsp;
 * @include_optional: &nbsp;
 */
/**
 * listaller_dependency_contains_directive:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @str: &nbsp;
 */
/**
 * listaller_dependency_process_directives:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @directive_str: &nbsp;
 * @error: (error-domains ListallerDepComponentError): location to store the error occuring, or %NULL to ignore
 * 
 * Returns: Value of the directives found 
 */
/**
 * listaller_dependency_get_version:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @error: (error-domains ListallerDepComponentError): location to store the error occuring, or %NULL to ignore
 */
/**
 * listaller_dependency_set_version:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @new_version: &nbsp;
 */
/**
 * listaller_dependency_has_item:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @kind: &nbsp;
 * @val: &nbsp;
 */
/**
 * listaller_dependency_has_matching_item:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @kind: &nbsp;
 * @val: &nbsp;
 */
/**
 * listaller_dependency_has_items:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 */
/**
 * listaller_dependency_get_installed_items_as_string:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 */
/**
 * listaller_dependency_has_installed_items:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 */
/**
 * listaller_dependency_has_feed:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 */
/**
 * listaller_dependency_get_install_dir_for_setting:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * @setup_setting: &nbsp;
 * 
 * Get installation directory for this module, using the SettupSettings taken as argument
 */
/**
 * listaller_dependency_get_metadata_xml:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 */
/**
 * listaller_dependency_build_pk_package_id:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * 
 * Generate a PackageKit package-id for this dependency information
 */
/**
 * listaller_dependency_is_valid:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance
 * 
 * Returns %TRUE if the dependency is valid (= contains sane data)
 */
/**
 * listaller_dependency_new:
 */
/**
 * ListallerDependency:metainfo:
 */
/**
 * listaller_dependency_get_metainfo:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--metainfo"><type>"metainfo"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--metainfo"><type>"metainfo"</type></link> property
 */
/**
 * listaller_dependency_set_metainfo:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerDependency--metainfo"><type>"metainfo"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerDependency--metainfo"><type>"metainfo"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerDependency:unique-name:
 */
/**
 * listaller_dependency_get_unique_name:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--unique-name"><type>"unique-name"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--unique-name"><type>"unique-name"</type></link> property
 */
/**
 * listaller_dependency_set_unique_name:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerDependency--unique-name"><type>"unique-name"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerDependency--unique-name"><type>"unique-name"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerDependency:architecture:
 */
/**
 * listaller_dependency_get_architecture:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--architecture"><type>"architecture"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--architecture"><type>"architecture"</type></link> property
 */
/**
 * listaller_dependency_set_architecture:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerDependency--architecture"><type>"architecture"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerDependency--architecture"><type>"architecture"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerDependency:installed:
 */
/**
 * listaller_dependency_get_installed:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--installed"><type>"installed"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--installed"><type>"installed"</type></link> property
 */
/**
 * listaller_dependency_set_installed:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerDependency--installed"><type>"installed"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerDependency--installed"><type>"installed"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerDependency:origin:
 */
/**
 * listaller_dependency_get_origin:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--origin"><type>"origin"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--origin"><type>"origin"</type></link> property
 */
/**
 * listaller_dependency_set_origin:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerDependency--origin"><type>"origin"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerDependency--origin"><type>"origin"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerDependency:install-time:
 */
/**
 * listaller_dependency_get_install_time:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--install-time"><type>"install-time"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--install-time"><type>"install-time"</type></link> property
 */
/**
 * listaller_dependency_set_install_time:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerDependency--install-time"><type>"install-time"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerDependency--install-time"><type>"install-time"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerDependency:environment:
 */
/**
 * listaller_dependency_get_environment:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--environment"><type>"environment"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--environment"><type>"environment"</type></link> property
 */
/**
 * listaller_dependency_set_environment:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerDependency--environment"><type>"environment"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerDependency--environment"><type>"environment"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerDependency:feed-url:
 */
/**
 * listaller_dependency_get_feed_url:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--feed-url"><type>"feed-url"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--feed-url"><type>"feed-url"</type></link> property
 */
/**
 * listaller_dependency_set_feed_url:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerDependency--feed-url"><type>"feed-url"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerDependency--feed-url"><type>"feed-url"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerDependency:installed-items:
 */
/**
 * listaller_dependency_get_installed_items:
 * @self: the <link linkend="ListallerDependency"><type>ListallerDependency</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerDependency--installed-items"><type>"installed-items"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerDependency--installed-items"><type>"installed-items"</type></link> property
 */
/**
 * ListallerDependency:
 * 
 * Definition of a dependency of an application
 * 
 * <para>Contains a #AsComponent which holds the actual information about the referenced component-dependency.</para>
 */
/**
 * ListallerDependencyClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-TYPE-DEPENDENCY:CAPS"><literal>LISTALLER_TYPE_DEPENDENCY</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * ListallerDepComponentError:
 */
