###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import os, sys,traceback,time
import gobject


import utils
from song import *

COMMIT_PERIOD = 5*60*60

DEBUG={}
DEBUG["requete"]=False
DEBUG["db"]=False

from pysqlite2 import dbapi2 as sqlite


class ListenDBManager(object):
    def __init__(self,check_exist = False):
        self.db = ListenDB(check_exist)
        self.random_cache = []

    def get_all_songs(self,where="",orderby=""):
        if where!="":
            where = "WHERE "+where

        if orderby=="":
            orderby="LOWER(artist),LOWER(album),CAST (tracknr AS int),LOWER(title)"
        query = "SELECT * FROM songs "+where+" ORDER BY "+orderby+";"
        res = self.db.select_request(query)

        array_song = []
        for record in res:
            song = Song()
            song.read_from_dict(record)
            array_song.append(song)

        return array_song

    def set_random_song_cache(self):
        #query = "SELECT * FROM songs WHERE id>=abs(random(*))%(SELECT max(id) from songs) LIMIT 1;"
        query = "select *  from songs GROUP BY id ORDER BY random(id) LIMIT 100;"
        res = self.db.select_request(query)
        """ made a cache of the random value because this select it too long to execute """
        self.random_cache = res

    def get_random_song(self):
        if len(self.random_cache)==0: self.set_random_song_cache()
    	if len(self.random_cache)== 0 or self.random_cache==None:
    	   song = None
    	else:
            res = self.random_cache.pop(0)
    	    song = Song()
    	    song.read_from_dict(res)
        if len(self.random_cache)==0: gobject.idle_add(self.set_random_song_cache)
    	return song

    def get_songs_custom(self,query):

        res = self.db.select_request(query)
        array_song = []
        for record in res:
            song = Song()
            song.read_from_dict(record)
            array_song.append(song)

        return array_song

    def close(self):
        TRY = 10
        e = ""
        while TRY!=0:
            try:
                self.db.write()
                #self.db.close()
                break
            except Exception,e:
                print "Can't save database retry"
                #time.sleep(0.1)
                TRY -= 1
        if TRY==0:
            print "Error while saving database:",e


    def write(self):
        try:self.db.write()
        except Exception,e:
            print "Failed save database" ,e

    """ Update "list_property" or all field of a song to the DB """
    def update_song(self,song,list_property=None):
        for property in DB_KEY:
            if list_property == None or property in list_property:
                value = song.get_property(property)
                #print property
                if property in INTEGER_KEY and value!=None:
                    value = "%d"%value
                    self.db.set_media_property(song.get_property("id"),property,value)
                elif property in BOOL_KEY:
                    if value: value="1"
                    else: value="0"
                    self.db.set_media_property(song.get_property("id"),property,value)
                elif value!=None:
                    if not isinstance(value,str):
                        value =value.decode("utf-8", "ignore")
                    value=utils.sqlescape(value)
                    self.db.set_media_property(song.get_property("id"),property,value)
                else:
                    self.db.delete_media_property(song.get_property("id"),property)


    def get_iradio(self):
        query = "SELECT * from iradio;"
        res = self.db.select_request(query)
        array_song = []
        for record in res:
            song = Song()
            song.read_from_dict(record)
            song.iradio=True
            array_song.append(song)

        return array_song


    def delete_song(self,song):
        self.db.delete_media(song.get_property("id"))

    """ Need rename to media """
    def get_song_by_id(self,id,try_iradio=False,try_podcast=True):#iradio for playlist

        query1 = "SELECT * FROM songs s WHERE s.id=%d"%id
        res = self.db.select_request(query1)
        if try_iradio:
            query2 = "SELECT * FROM iradio r WHERE  r.id=%d"%id
            res.extend(self.db.select_request(query2))
        if try_podcast:
            query3 = "SELECT * FROM  podcast p WHERE p.id=%d"%id
            res.extend(self.db.select_request(query3))
        if len(res)==0:
            return None
        elif len(res)>1:
            print "DB Problem get_song_by_id() return more than one song (Report plz)"

        song = Song()
        song.read_from_dict(res[0])
        return song


    def get_song_by_uri(self,uri,parse_not_exist=True):
        if not os.path.exists(utils.get_path(uri)):
            return None
        query1 = "SELECT id FROM songs s WHERE s.uri='%s' LIMIT 1; "%utils.sqlescape(uri)
        res = self.db.select_request(query1)
        if len(res)==0:
            id = self.db.get_or_add_media(uri)
            song = Song()
            song.set_property("uri",utils.fsdecode(uri))
            song.set_property("id",id)
            #Add control if not a local file
            if parse_not_exist:
                if song.read_from_file():
                    self.update_song(song)
                else:
                    self.delete_song(song)
                    #print utils.fsdecode(uri),": ", song.last_error
                    return None
        else:
            song = self.get_song_by_id(res[0]["id"],False,False)
        return song

        """query = "SELECT * FROM songs WHERE uri='%s';"%utils.sqlescape(uri)
        res = self.db.select_request(query)
        song = Song()
        if len(res)==0 or res==None:
            id = self.db.get_or_add_media(uri)
            song.set_property("uri",utils.fsdecode(uri))
            song.set_property("id",id)
            #Add control if not a local file
            if parse_not_exist:
                if song.read_from_file():
                    self.update_song(song)
                else:
                    self.delete_song(song)
                    #print utils.fsdecode(uri),": ", song.last_error
                    return None
        else:
            song.read_from_dict(res[0])"""
        return song

    def get_iradio_by_uri(self,uri):

        query = "SELECT * FROM iradio WHERE uri='%s';"%utils.sqlescape(uri)
        res = self.db.select_request(query)
        song = Song()
        if len(res)==0 or res==None:
            id = self.db.get_or_add_media(uri)
            song.set_property("uri",uri)
            song.set_property("id",id)
            song.set_property("iradio","1")
            self.update_song(song)
        else:
            song.read_from_dict(res[0])
        return song


    def get_songs_from_playlist(self,id_playlist):
        res = self.db.select_request("SELECT id_media FROM playlists WHERE id_playlist=%d ORDER by pos;"%id_playlist)
        list_song = []
        for i in range(0,len(res)):
            song = self.get_song_by_id(res[i]["id_media"],(id_playlist==0))
            if song!=None:
                list_song.append(song)
        return list_song

    def get_songs_from_playlist_by_name(self,name_playlist):
        return self.get_songs_from_playlist(self.get_playlist_by_name(name_playlist)["id"])

    def get_playlists(self,where=""):
        if where!="":
            where = "WHERE "+where
        return self.db.select_request("SELECT * FROM playlist "+where+" ORDER BY name")

    def get_playlist_by_name(self,name_playlist):
        res = self.db.select_request("SELECT * FROM playlist WHERE name='%s' LIMIT 1;"%utils.sqlescape(name_playlist))
        if len(res)==1:
            return res[0]
        else:
            return None

    def add_playlist(self,name):
        query = "INSERT INTO playlist (name) VALUES ('%s');"%utils.sqlescape(name)
        self.db.execute(query)
        return self.get_playlist_by_name(name)["id"]


    def add_song_to_playlist(self,song,id):
        query = """
            INSERT INTO playlists (id_playlist,id_media,pos)
            VALUES (
                    %d,%d,
                    (SELECT max(pos) FROM playlists WHERE id_playlist=%d)
                   );
        """%(id,song.get_property("id"),id)
        self.db.execute(query)

    def clear_playlist(self,id):
        self.db.execute("DELETE FROM playlists WHERE id_playlist=%d;"%id)

    def delete_playlist(self,id):
        self.clear_playlist(id)
        self.db.execute("DELETE FROM playlist WHERE id=%d;"%id)

    def rename_playlist(self,id,name):
        self.db.execute("UPDATE playlist SET name='%s' WHERE id=%d ;"%(utils.sqlescape(name),id))

    def get_albums(self,where="",orderby="LOWER(album), LOWER(artist)"):
        if where!="":
            where = "WHERE "+where
        query = "SELECT * FROM albums "+where+" ORDER by "+orderby+" ;"
        res = self.db.select_request(query)
        return res

    def get_artists(self,where="",orderby="LOWER(artist)"):
        if where!="":
            where = "WHERE "+where
        query = "SELECT * FROM artists "+where+" ORDER by "+orderby+" ;"
        res = self.db.select_request(query)
        return res
    def get_genres(self,where="",orderby="LOWER(genre)"):
        if where!="":
            where = "WHERE "+where
        query = "SELECT * FROM genres "+where+" ORDER by "+orderby+" ;"
        res = self.db.select_request(query)
        return res

    def select_request(self,query):
        return self.db.select_request(query)

    """def get_podcast_feeds(self,where="",orderby="LOWER(title)"):
        if where!="":
            where = "WHERE "+where
        query = "SELECT * FROM podcast_feed "+where+" ORDER by "+orderby+" ;"
        res = self.db.select_request(query)
        return res"""

    def get_podcasts(self,where="",orderby="date+1-1 DESC"):
        if where!="":
            where = "WHERE "+where

        query = "SELECT * from podcast %s ORDER BY %s;"%(where,orderby)
        res = self.db.select_request(query)
        array_song = []
        for record in res:
            song = Song()
            song.read_from_dict(record)
            array_song.append(song)
        return array_song

    """def add_podcast_feed(self,uri,title,date,description,image=None):
        id = self.db.get_or_add_media(uri)
        self.db.set_media_property(id, "title", utils.sqlescape(title))
        self.db.set_media_property(id, "description", utils.sqlescape(description))
        self.db.set_media_property(id, "date", date,True)
        if image !=None:
            self.db.set_media_property(id, "image", image)
        self.db.set_media_property(id,"podcast_feed","1")
        return {"id":id,"title":title,"image":image,"description":description}"""

    """def delete_podcast_feed(self,id):
        self.db.delete_media(id)"""

    def get_podcast_by_uri(self,uri):
        id = self.db.get_or_add_media(uri)
        self.db.set_media_property(id,"podcast","1")
        songs = self.get_podcasts("id=%d"%id)
        if len(songs)>0:
            return songs[0]
        else:
            return None


class ListenDB( gobject.GObject ):
    def __init__( self ,check_exist = False):
        gobject.GObject.__init__( self )

        self.nb_statement = 0
        self.HOME_DIR    = os.path.expanduser( "~" )
        self.CONFIG_DIR     = os.path.join( self.HOME_DIR+"/.listen/" )
        self.DB_NAME  = os.path.join( self.CONFIG_DIR, "media.db" )
        if check_exist:
            if not os.path.isfile( self.DB_NAME ):
                self.con = sqlite.connect( self.DB_NAME )
                self.cur = self.con.cursor()
                print "LISTEN : CREATE DATABASE"
                requete_media = """
                   CREATE TABLE
                        Media
                        (
                          id       integer,
                          key      varchar(20),
                          value    TEXT,
                          PRIMARY KEY (id,key)
                        );
                    """

                requete_playlist_view = """
                    CREATE TABLE playlist
                        (
                          id       integer PRIMARY KEY AUTOINCREMENT,
                          name      varchar(20)
                        );

                    """
                requete_playlists_view = """
                    CREATE TABLE playlists
                        (
                          id       integer PRIMARY KEY AUTOINCREMENT,
                          id_playlist       integer,
                          id_media      integer,
                          pos        integer UNIQUE
                        );
                    """

                requete_playlist_view_first_value = """INSERT INTO playlist VALUES (0,"__autosaved__");"""
                self.cur.execute( requete_media )
                self.cur.execute( requete_playlist_view )
                self.cur.execute( requete_playlists_view )
                self.cur.execute( requete_playlist_view_first_value )


                self.con.commit()
                self.ipod_mount_point = {}
            else:
                self.con = sqlite.connect( self.DB_NAME )
                self.cur = self.con.cursor()

            requete_songs_view = """
                CREATE VIEW songs AS
                        SELECT m1.id as id , m1.value as uri, m2.value as title, m3.value as album, m14.value as genre,
                                m4.value as artist, m5.value as duration, m6.value as tracknr,m10.value as playcount, m15.value as date
                                ,m11.value as last_played
                        FROM Media m1
                             LEFT OUTER JOIN Media m2 ON m1.id = m2.id AND m2.key='title'
                             LEFT OUTER JOIN Media m3 ON m1.id = m3.id AND m3.key='album'
                             LEFT OUTER JOIN Media m4 ON m1.id = m4.id AND m4.key='artist'
                             LEFT OUTER JOIN Media m5 ON m1.id = m5.id AND m5.key='duration'
                             LEFT OUTER JOIN Media m6 ON m1.id = m6.id AND m6.key='tracknr'
                             LEFT OUTER JOIN Media m7 ON m1.id = m7.id AND m7.key='iradio'
                             LEFT OUTER JOIN Media m12 ON m1.id = m12.id AND m12.key='podcast'
                             LEFT OUTER JOIN Media m13 ON m1.id = m13.id AND m13.key='podcast_feed'
                             LEFT OUTER JOIN Media m10 ON m1.id = m10.id AND m10.key='playcount'
                             LEFT OUTER JOIN Media m11 ON m1.id = m11.id AND m11.key='last_played'
                             LEFT OUTER JOIN Media m14 ON m1.id = m14.id AND m14.key='genre'
                             LEFT OUTER JOIN Media m15 ON m1.id = m15.id AND m15.key='date'
                             LEFT OUTER JOIN Media m8 ON m1.id = m8.id AND m8.key='removable'
                        WHERE m1.key = 'uri' AND (m7.value='0' OR m7.value is null)
                                AND (m8.value='0' OR m8.value is null)
                                AND (m12.value='0' OR m12.value is null)
                                AND (m13.value='0' OR m13.value is null)
                    ;

                """
            #SQLITE HACK duration+1-1 == CAST (duration as int)
            requete_albums_view = """
                CREATE VIEW albums AS
                    SELECT album,artist ,count(id) as nb_song,
                    avg(CAST (playcount as int)) as playcount ,
                    sum(CAST (duration as int)) as duration
                    FROM songs
                    GROUP BY album,artist
                ;

                """
            #SQLITE HACK duration+1-1 == CAST (duration as int)
            __requete_artists_view = """
                CREATE VIEW artists AS
                    SELECT artist,count(album) as nb_album ,sum(nb_song)  as nb_song,
                    avg(playcount) as playcount,
                    sum(duration+1-1) as duration
                    FROM (SELECT artist ,album,count(id) as nb_song,
                        avg(CAST (playcount as int)) as playcount,
                        sum(CAST (duration as int)) as duration
                        FROM songs GROUP BY artist,album)
                    GROUP BY artist
                ;
                """
            #SQLITE HACK duration+1-1 == CAST (duration as int)
            requete_genres_view = """
                CREATE VIEW genres AS
                    SELECT genre FROM songs GROUP BY genre
                ;
                """

            #More simple but don't work in sqlite < 2.3.6
            requete_artists_view = """
                CREATE VIEW artists AS
                    SELECT artist,count(DISTINCT (album)) as nb_album ,count(id)  as nb_song,
                    avg(CAST (playcount as int)) as playcount,
                    sum(CAST (duration as int)) as duration
                    FROM songs
                    GROUP BY artist
                ;
                """

            requete_iradio_view = """
                CREATE VIEW iradio AS
                    SELECT m1.id as id , m1.value as uri, m2.value as title,m7.value as iradio
                    FROM Media m1
                         LEFT OUTER JOIN Media m2 ON m1.id = m2.id AND m2.key='title'
                         LEFT OUTER JOIN Media m7 ON m1.id = m7.id AND m7.key='iradio'
                    WHERE m1.key = 'uri' AND m7.value='1'
                    ;
                """


            requete_podcast_view = """
                CREATE VIEW podcast AS
                    SELECT m1.id as id ,
                        m1.value as uri,
                        m2.value as title,
                        m3.value as duration,
                        m4.value as description,
                        m7.value as podcast,
                        m8.value as podcast_local_uri,
                        m10.value as date,
                        m11.value as podcast_feed_title,
                        m9.value as podcast_feed_uri,
                        m12.value as podcast_feed_image,
                        m13.value as podcast_feed_description,
                        m14.value as podcast_feed_date
                    FROM Media m1
                         LEFT OUTER JOIN Media m2 ON m1.id = m2.id AND m2.key='title'
                         LEFT OUTER JOIN Media m3 ON m1.id = m3.id AND m3.key='duration'
                         LEFT OUTER JOIN Media m4 ON m1.id = m4.id AND m4.key='description'
                         LEFT OUTER JOIN Media m7 ON m1.id = m7.id AND m7.key='podcast'
                         LEFT OUTER JOIN Media m8 ON m1.id = m8.id AND m8.key='podcast_local_uri'
                         LEFT OUTER JOIN Media m9 ON m1.id = m9.id AND m9.key='podcast_feed_uri'
                         LEFT OUTER JOIN Media m10 ON m1.id = m10.id AND m10.key='date'
                         LEFT OUTER JOIN Media m11 ON m1.id = m11.id AND m11.key='podcast_feed_title'
                         LEFT OUTER JOIN Media m12 ON m1.id = m12.id AND m12.key='podcast_feed_image'
                         LEFT OUTER JOIN Media m13 ON m1.id = m13.id AND m13.key='podcast_feed_description'
                         LEFT OUTER JOIN Media m14 ON m1.id = m14.id AND m14.key='podcast_feed_date'
                    WHERE m1.key = 'uri' AND m7.value='1'
                    ;
                """

            try:self.cur.execute( "DROP VIEW songs" )
            except sqlite.OperationalError: pass
            try:self.cur.execute( "DROP VIEW albums"  )
            except sqlite.OperationalError: pass
            try:self.cur.execute( "DROP VIEW artists"  )
            except sqlite.OperationalError: pass
            try:self.cur.execute( "DROP VIEW iradio"  )
            except sqlite.OperationalError: pass
            try:self.cur.execute( "DROP VIEW podcast"  )
            except sqlite.OperationalError: pass
            try:self.cur.execute( "DROP VIEW genres"  )
            except sqlite.OperationalError: pass

            self.cur.execute( requete_songs_view )
            self.cur.execute( requete_albums_view )
            self.cur.execute( requete_artists_view )
            self.cur.execute( requete_iradio_view )
            self.cur.execute( requete_genres_view )
            self.cur.execute( requete_podcast_view )

            self.con.commit()
            #End check exist
        else:
            self.con = sqlite.connect( self.DB_NAME )
            self.cur = self.con.cursor()

        """
        some optimisation found at:
        http://web.utk.edu/~jplyon/sqlite/SQLite_optimization_FAQ.html
        """
        self.cur.execute("PRAGMA synchronous=OFF");
        self.cur.execute("PRAGMA count_changes = 0");
        self.cur.execute("PRAGMA auto_vacuum =  1");
        self.cur.execute("PRAGMA cache_size =  4000");
        self.cur.execute("PRAGMA temp_store = MEMORY; ");
        """ Perhaps  unuseful i don't find if linux support it"""
        self.cur.execute(" PRAGMA fullfsync = 0");

    def execute( self, request ):
        self.debug( "--> execute(%s)"% request)
        self.cur.execute( request )
        self.debug( "<-- execute(%s)"% request)

    def select( self, request ):
        self.debug( "--> select(%s)"%request )
        try:self.cur.execute( request )
        except OperationalError: raise "SQL ERROR :",request
        res = []
        for row in self.cur:
            res.append( row )
        self.debug( "<-- select(%s)"%request )
        return res

    def select_request( self, request, debug=False ):
        self.debug( "--> select_request(%s)"% request)
        if DEBUG["requete"]: print request
        try:self.cur.execute( request )
        except Exception,e:
            print "SQL ERROR ",e,request
            print traceback.format_exc()

        field_list = []
        res = []
        if self.cur.description is None:
            self.debug( "<-- select_request:",len(res))
            return res;

        for fieldDesc in self.cur.description:
            field_list.append( fieldDesc[0] )
        fieldIndices = range( len( self.cur.description ) )

        for row in self.cur:
            #if self.verbose : print "row :", row
            dict = {}
            for fieldIndex in fieldIndices:

                if isinstance(row[fieldIndex],int) or isinstance(row[fieldIndex],float):
                    dict[field_list[fieldIndex]] = int(row[fieldIndex])
                elif  row[fieldIndex]  == None:
                    dict[field_list[fieldIndex]] = ""
                else:
                    dict[field_list[fieldIndex]] = utils.sqlunescape(row[fieldIndex])
            res.append( dict )
        self.debug( "<-- select_request: ",len(res))
        return res

    def delete_media_property( self, id, key ):
        self.debug( "--> delete_media_property(%d,%s)"%( id, key ) )
        self.cur.execute( "DELETE FROM Media WHERE id=%d and key='%s';"%( id, key ) )
        self.debug( "<-- delete_media_property(%d,%s)"%( id, key ) )

    def set_media_property( self, id, key, value):

        self.debug( "--> set_media_property(%d,%s,%s)"%( id, key, value ) )

        self.delete_media_property( id, key )
        query = "INSERT INTO Media (id, key,value) VALUES (%d,'%s','%s') ;"%( id, key, value )
        self.debug(query)
        try:
            self.cur.execute( query )
        except :
            print query
            #print self.get_media(id)
            self.close()
            raise
            exit()
        self.debug("<-- set_media_property(%d,%s,%s)"%(id,key,value))


    def delete_media(self,id):
        self.debug("--> delete_media(%d)"%id)
        self.cur.execute("DELETE FROM Media WHERE id=%d ;"%id)
        self.debug("<-- delete_media(%d)"%id)


    def get_or_add_media(self,uri,verif_exist=True):
        #Verify Media not already exist
        self.debug("--> add_media("+uri+")")
        uri = utils.sqlescape(uri)
        if verif_exist:

            self.cur.execute("SELECT id FROM Media WHERE key='uri' and value='%s' ;"%uri)
            id = 0
            number_row = 0
            for row in self.cur:
                number_row += 1
                id = row[0]
        else:
            number_row = 0

        if number_row == 0: #Media not exist add it
            self.cur.execute("SELECT max(id) as new_id FROM Media;")
            new_id = 0
            for row in self.cur:
                #print row
                if row[0] == None:
                    new_id = 0
                else:
                    new_id = row[0]
                    new_id +=1

            self.debug("NOT EXIST : NEW ID = %d"%new_id)
            self.cur.execute("INSERT INTO Media (id, key,value) VALUES (%d,'uri','%s') ;"%(new_id,uri))
            self.debug("<-- add_media("+uri+"):",new_id)
            return new_id

        elif number_row == 1:
            self.debug("ALREADY EXIST : ID = %d "%id)
            self.debug("<-- add_media("+uri+"):",id)
            return id

        else :
            print "ERROR : Media entry %s appear more than 1 times in Media Library"%uri
            sys.exit(-1)

        self.debug("<-- add_media()")
        return None

    def write(self):
        self.con.commit()

    def close(self):
        self.con.close()

    def debug(self,*param):
        if DEBUG["db"] :
            if param[0].rfind("-->")!=-1:
                self.nb_statement += 1
            if param[0].rfind("<--")!=-1:
                self.nb_statement -= 1
            print "ListenDB() : ",param
            print "statement pending:",self.nb_statement


"""First DB launch check exist create it if needed"""
DBManager = ListenDBManager(True)
gobject.timeout_add(COMMIT_PERIOD,DBManager.write)
