###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gobject
import gtk
from time import time
import os, sys

from db_manager import DBManager
from song import *


class FileInspector( gobject.GObject ):
    def __init__( self ):
        gobject.GObject.__init__( self )
        self.verbose = False
        self.total = 0
        self.courant = 0
        self.ready = False
        self.current_info = {}

    def is_ready(self):
        return self.ready

    def get_info(self):
        return self.current_info;

    def check_db(self,reparse_tag=False):
        self.debut = time()
        self.songs = DBManager.get_all_songs()
        self.total = len( self.songs )
        self.courant = 0
        self.current_info["total"] = self.total
        print "NB FILE TO SCAN: %d"%self.total
        def check_file():
            self.ready = True
            if len(self.songs)==0:
                self.current_info = None
                fin = time()
                duree = fin-self.debut
                print "SCAN TIME: %d s"%duree
                return False
            else:
                song = self.songs.pop(0)
                self.current_info["num"] = self.courant
                self.current_info["file"] = song.get_property("uri")
                self.courant +=1
                if song.get_ext() not in READ_EXTENTIONS or not os.path.exists(song.get_path()):
                    DBManager.delete_song(song)
                elif reparse_tag:
                    song.read_from_file()
                    DBManager.update_song(song)
                return True
        gobject.idle_add(check_file)

    def parse_directory( self, dirs ):

        def parse_dir(dir,last_m_fn="",last_path_fn=""):
            local_list = []
            for path, dnames, fnames in os.walk( dir ):
                #print dnames
                """ Read all files listed in directory and sub directory"""
                for fn in fnames:
                    #print fnames
                    if fn[0]=='.':
                        continue
                    while gtk.events_pending(): gtk.main_iteration()
                    if utils.get_ext(fn) in READ_EXTENTIONS:
                        """don't re-resolve this path every time"""
                        if last_path_fn == path+fn:
                            m_fm = last_m_fn
                        else:
                            path_fn = os.path.join( path, fn )
                            m_fn = os.path.realpath( path_fn )
                            last_m_fn = m_fn
                            last_path_fn = path+fn
                        """ Add it only if i can't read the filename correctly "" "
                        try: m_fn.encode("utf-8")
                        except: pass
                        else:
                        """
                        local_list.append( m_fn )
                """ find link and follow it if it is a directory"""
                for dn in dnames:
                    if dn[0]==".":
                        dnames.remove(dn)
                        continue  
                    path_dn = os.path.join( path, dn )
                    if os.path.islink(path_dn):
                        d_dn = os.path.realpath( path_dn )
                        local_list.extend(parse_dir(d_dn,last_m_fn,last_path_fn))

            return local_list

        self.debut = time()
        d = os.path.expanduser( dirs )

        self.uri_cache = DBManager.db.select_request("SELECT uri AS uri from songs ")
        self.uri_cache = list([utils.sqlescape(uri["uri"][7:]) for uri in self.uri_cache])
        self.list_uri = parse_dir(d)

        #self.list_uri = filter(lambda s:s not in self.list_uri,self.uri_cache)
        if len(self.list_uri)>0  and len(self.uri_cache)>0:
            print "filter"
            """
            Remove uri already in db before parse it

            Python big array manipulation too slow

            Change to a pysqlite version more quick
            TEST with 2 array of 10000 item python : 45s sqlite: 6sec ;)
            """
            try:DBManager.db.execute("DROP TABLE tmp;");
            except:pass
            DBManager.db.execute("CREATE TABLE tmp(uri varchar(255));");
            for uri in self.list_uri:
                DBManager.db.execute("INSERT INTO tmp (uri) VALUES ('%s')"%utils.sqlescape(uri));
            self.list_uri = DBManager.db.select_request("SELECT uri AS uri FROM tmp WHERE uri not in ('%s');"%"','".join(self.uri_cache));
            self.list_uri = list([uri["uri"] for uri in self.list_uri])
            #print self.list_uri
            print "filter finish"


        if len(self.list_uri)<=0:
            self.ready = True
            self.current_info = None
            print "Nothing to add"
            return
        self.total = len( self.list_uri )
        self.courant = 0
        self.current_info["total"] = self.total
        self.current_info["num"] = self.courant
        self.current_info["file"] = self.list_uri[0]
        print "NB FILE TO LOAD %d"%self.total

        def parse_file():
            self.ready = True
            if len(self.list_uri)==0:

                DBManager.write()
                self.current_info = None
                fin = time()
                duree = fin-self.debut
                print "LOADING TIME: %d s"%duree
                return False
            else:
                fin = time()
                duree = fin-self.debut
                file = self.list_uri.pop(0)

                self.current_info["num"] = self.courant
                self.current_info["file"] = file
                self.courant +=1
                song = Song()
                song.set_property("uri","file://"+utils.fsdecode(file))
                id = DBManager.db.get_or_add_media(song.get_property("uri"),False)
                song.set_property("id",id)
                song.read_from_file()
                DBManager.update_song(song)

                #song = DBManager.get_song_by_uri("file://"+file)
                return True

        gobject.idle_add(parse_file)



    def debug( self, str ):
        if self.verbose : print "FileInspector() : "+str

