###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###
# Based on quolibet code for read/write metadata
#   (C) Copyright 2004-2005 Joe Wreschnig, Michael Urman
###

import mutagen.flac
import gst
from song import READ_EXTENTIONS,WRITE_EXTENTIONS

def read(song):
    IDS = {
        "title": "title",
        "artist": "artist",
        "album": "album",
        "bitrate": "bitrate",
        'tracknumber':"tracknr",
        'genre':"genre",
        "date":"date"
    }

    f = mutagen.flac.FLAC(song.get_path())
    for key, value in (f.tags or {}).items():
        if IDS.has_key(key):
            song.set_property(IDS[key],list(value)[0].encode("utf-8"))
    song.set_property("duration",int(f.info.length)*1000)

def write(song):
    IDS = {
        "title": "title",
        "artist": "artist",
        "album": "album",
        "tracknumber": "tracknr",
        'genre':"genre",
        "date":"date"
    }
    f = mutagen.flac.FLAC(song.get_path())
    if f.tags is None: f.add_tags()
    del(f.tags[:])
    for key,value in IDS.iteritems():
        value = song.sprint(value)
        if value!="":
            f.tags[key] = value
    f.save()

try: import mutagen.flac
except ImportError: pass
else:
    try: gst.element_factory_make('flacdec')
    except:pass
    else:
        WRITE_EXTENTIONS[".flac"]= write
        READ_EXTENTIONS[".flac"]= read
        
        