###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import os
import gst
import gobject
import gtk
from time import time
from datetime import datetime
import gst
import threading
import urllib
import amazon
from copy import copy
try: import gpod
except: pass

"""This is a dict with read/write metadata fonction for each extention """
WRITE_EXTENTIONS = {}
READ_EXTENTIONS = {}

PLAYLIST_EXTENTION = [".m3u",".pls"]

import utils
import config
import formats.oggvorbis
import formats.mp3
import formats.mp4
import formats.flac

def get_supported_extention():
    string = "Extension support tag reading: \n"+str(READ_EXTENTIONS.keys())
    string += "\nExtension support tag writting: \n"+str(WRITE_EXTENTIONS.keys())
    return string

if False:
    print get_supported_extention()


"""
List of album covers that I have already tried
to download on amazon website and which failed
this list is reinitialized every 30min
"""
ALBUM_COVER_TO_SKIP = []
def reinit_skip_album_cover():
    ALBUM_COVER_TO_SKIP = []
REINIT_ALBUM_COVER_TO_SKIP_TIME = 100*60*30
gobject.timeout_add(REINIT_ALBUM_COVER_TO_SKIP_TIME,reinit_skip_album_cover)

INTEGER_KEY=["ipod_id","id","duration","size","tracknr","bitrate","last_played","rate","playcount","podcast_feed_date"]
BOOL_KEY = ["iradio","podcast","tagged"]

""" Key to save in DB """
DB_KEY = [ "id", "title", "artist", "album",
        "uri", "duration", "size", "tracknr", "rate",
        "bitrate", "last_played", "ipod_id", "ipod_mount_point",
        "playcount", "iradio", "date", "podcast","podcast_feed_uri",
        "podcast_feed_title", "podcast_local_uri", "podcast_feed_image",
        "description","podcast_feed_description","podcast_feed_date","genre"
                   ]

class Song:
    def __init__(self):
        #gobject.GObject.__init__(self)
        self.id = None
        self.title = None
        self.artist = None
        self.album = None
        self.uri = None
        self.duration = None
        self.size = None
        self.tracknr = None
        self.bitrate = 0
        self.genre = None
        self.last_played = 0
        self.playcount = 0
        self.rate = 0

        self.date = None

        self.iradio = False
        self.podcast = False
        self.description = None
        self.podcast_local_uri = None
        self.podcast_feed_title = None
        self.podcast_feed_image = None
        self.podcast_feed_description = None
        self.podcast_feed_date = None
        self.podcast_feed_uri = None

        self.ipod_track = None

        #FIXME remove ipod_id and use ipod_track.id
        self.ipod_id = None
        self.ipod_mount_point = None

        self.last_error = ""
        self.tagged=False
        #self.local_media = False

    def __sort_key(self):
        return (
                self.sprint("artist").lower(),
                self.sprint("album").lower(),
                self.get_int("tracknr"),
                self.sprint("title").lower(),
                self.sprint("uri").lower()
                )
    sort_key = property(__sort_key)

    def __hash__(self):
        return hash(self.get_property("uri"))


    def __cmp__(self, other):
        if not other: return -1
        try: return cmp(self.sort_key, other.sort_key)
        except AttributeError: return -1

    def __eq__(self,other):
        try:return self.get_property("uri")==other.get_property("uri")
        except:return False

    def get_filter(self):
        """self.sprint("genre").strip().lower(),"""
        return " ".join([
                self.sprint("artist").strip().lower(),
                self.sprint("album").strip().lower(),
                self.sprint("title").strip().lower(),
                        ])

    def get_int(self,property):
        if property not in INTEGER_KEY:
            raise "get_int() not allowed for ",property
        else:
            value =  self.get_property(property)
            #Just a control
            if value != None:
                assert(isinstance(value,int))
                return value
            else:
                return 0

    def set_property(self,property,value):
        if property in BOOL_KEY:
            setattr(self,property,bool(value))

        elif property=="tracknr":
            if value==None or value=="":
                setattr(self,property,None)
            else:
                if not isinstance(value,int) and value.rfind("/")!=-1:
                    value = value[0:value.rfind("/")]
                setattr(self,property,int(value))

        elif property=="ipod_id":
            if value==None or value=="":
                self.ipod_id=None
            else:
                self.ipod_id=int(value)

        elif property in INTEGER_KEY:
            if value==None or value=="":
                value = "0"
            setattr(self,property,int(value))
        else:
            setattr(self,property,value)

    def get_property(self,property):
        return getattr(self,property)

    def read_from_song(self,song):
        """ copy only db field """
        for field in DB_KEY:
            self.set_property(field,copy(song.get_property(field)))
        self.tagged = song.tagged

    def read_from_dict(self,dict):
        for key,value in dict.iteritems():
            self.set_property(key,value)
        self.tagged = True

    def sprint(self,property):
        value = self.get_property(property)
        if property in ["ipod_track"]:
            return "Couldn't print property ",property

        if (property=="podcast_date" or property=="date") and self.podcast:
            value = datetime.fromtimestamp(int(value)).isoformat(" ")
        if (property=="tracknr" or property=="date") and value==None:
            value = ""
        if value==None:
            value = ""
        if isinstance(value,int):
            value = "%d"%value
        if property=="title" and value=="":
            value = self.get_filename()
        #print property, " - ",value
        return value

    """""""""""""""""""""
        FILE READER
    """""""""""""""""""""
    def read_from_file(self):
        if self.get_protocol()!="file://":
            self.last_error = self.get_protocol()+" "+_("Protocol not supported")
            return False
        if not os.path.exists(self.get_path()):
            self.last_error = self.get_filename()+_(" doesn't exist")
            return False
        if not os.access(self.get_path(),os.R_OK):
            self.last_error = self.get_filename()+_(" doesn't have enough permission")
            return False


        self.tagged=False

        if READ_EXTENTIONS.has_key(self.get_ext()):
            try: READ_EXTENTIONS[self.get_ext()](self)
            except Exception, inst:
                #FIXME: Add a real tracback support
                print "W: Error while loading ("+self.get_path()+")\nTracback :",inst
                self.last_error = _("Error while reading")+": "+self.get_filename()
                return False
            else:
                self.tagged=True
                stats = os.stat(self.get_path())
                self.size = stats.st_size
                return True
        else:
           self.last_error = self.get_filename()+_(": file formats don't support tag reading")
           return False


    """""""""""""""""""""
        FILE WRITER
    """""""""""""""""""""


    def write_to_file(self):
        if self.get_protocol()!="file://":
            self.last_error = self.get_protocol()+" "+_("Protocol not supported")
            return False
        if not os.path.exists(self.get_path()):
            self.last_error = self.get_filename()+_(" doesn't exist")
            return False
        if not os.access(self.get_path(),os.W_OK):
            self.last_error = self.get_filename()+_(" doesn't have enough permission")
            return False

        if WRITE_EXTENTIONS.has_key(self.get_ext()):
            try: WRITE_EXTENTIONS[self.get_ext()](self)
            except Exception, inst:
                #FIXME: Add a real tracback support
                print "W: Error while writting ("+self.get_path()+")\nTracback :",inst
                self.last_error = _("Error while writting")+": "+self.get_filename()
                return False
            else:
                return True
        else:
            self.last_error = self.get_filename()+_(": file formats don't support tag writting")
            return False


    """
    Increase playcount and update last_played
    """
    def update_play_information(self):
        self.playcount = self.playcount+1
        self.last_played = time()


    """
    Some filename manipulation
    """
    def get_path(self):
        if self.podcast and self.podcast_local_uri!=None:
            return utils.fsencode(utils.get_path(self.podcast_local_uri))
        else:
            return utils.fsencode(utils.get_path(self.uri))

    def get_protocol(self):
        if self.podcast and self.podcast_local_uri!=None:
            return utils.get_protocol(self.podcast_local_uri)
        else:
            return utils.get_protocol(self.uri)

    def get_ext(self,complete=True):
        return utils.get_ext(self.uri,complete)

    def get_filename(self):
        if self.podcast and self.podcast_local_uri!=None:
            return utils.get_filename(self.podcast_local_uri)
        else:
            return utils.get_filename(self.uri)

    def get_error(self):
        return self.last_error

    """
    Get a tuple for SongTreeviewModel
    """
    def get_tuple_for_model_song(self):
        if self.podcast:
            try :
                date = int(self.get_property("date"))
                str_date = datetime.fromtimestamp(date).isoformat(" ")
            except:
                date=0
                str_date = ""

            return (self,date,self.sprint("title"),utils.duration_to_string(self.get_int("duration")),self.sprint("album"),self.sprint("artist"),str_date )
        else:
            return (self,self.get_int("tracknr"),self.sprint("title"),utils.duration_to_string(self.get_int("duration")),self.sprint("album"),self.sprint("artist"),self.sprint("tracknr") )



    """
    Delete album cover from harddisk
    """
    def remove_album_cover(self):
        image_path = self.get_album_cover_path()
        if image_path in ALBUM_COVER_TO_SKIP:
            del ALBUM_COVER_TO_SKIP[ALBUM_COVER_TO_SKIP.index(image_path)]
        if os.path.exists(image_path):
            os.unlink(image_path)

    """
    Return the name of the cover file without extention
    """
    def get_album_cover_search_str(self):
        art = ""
        if self.podcast:
            if self.sprint("podcast_feed_image")!="":
                art += self.sprint("podcast_feed_image")
        else:
            if self.sprint("artist")!="":
                art=self.sprint("artist")+"+"
            if self.sprint("album")!="":
                art+=self.sprint("album")

        art = art.replace(os.sep,"")
        art = utils.filter_info_song(art).encode('utf-8')
        return art

    """
    Return path of the local album art
    It can not exist
    """
    def get_album_cover_path(self):
        return config.CONFIG_DIR+"cover/"+self.get_album_cover_search_str()+".jpg"

    """
    Return path of the existing album art to display
    Or default cover if not found
    Must be ONLY use in a thread
    because it use amazon to get cover and if they don't have internet connection listen freeze
    """
    def get_album_cover(self,try_web=True):

        basedir = os.path.dirname(os.path.realpath(__file__))+"/"
        art = self.get_album_cover_search_str().encode('utf-8')

        default_image_path = config.DEFAULT_ALBUM_COVER

        image_path_disable = config.CONFIG_DIR+"cover/"+art+".jpg.#disable#"
        if os.path.exists(image_path_disable):
            return default_image_path

        image_path = config.CONFIG_DIR+"cover/"+art+".jpg"
        if os.path.exists(image_path):
            return image_path
        else:
            if image_path in ALBUM_COVER_TO_SKIP:
                return default_image_path

            """
            search in local directory
            artist.jpg,folder.jpg,album.jpg and same with png
            """
            if self.uri!=None and self.get_protocol()=="file://":
                filename = self.get_path()
                path = filename[:filename.rfind("/")]
                if os.path.exists(path):
                    list_file = os.listdir(path)
                    for f in list_file:
                        #print f.lower()
                        if f.lower() in ["artist.jpg","folder.jpg",".folder.jpg","album.jpg","artist.png","folder.png",".folder.png","album.png","cover.jpg","cover.png"]:
                            try : pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(path+"/"+f,75,75)
                            except gobject.GError: pass
                            else:
                                if os.path.exists(image_path):
                                    os.unlink(image_path)
                                pixbuf.save(image_path, "jpeg", {"quality":"85"})
                                del pixbuf
                                #print "Local cover found: ",f
                                return image_path


            if not try_web:
                return default_image_path
            else:
                try:
                    if self.podcast:
                        res = urllib.urlretrieve(self.podcast_feed_image, image_path)
                    else:
                        """ Try Amazon search """
                        amazon.setLicense("0RKH4ZH1JCFZHMND91G2")
                        bags = amazon.searchByKeyword(utils.remove_accents(art),type="lite", product_line="music")
                        res = urllib.urlretrieve(bags[0].ImageUrlSmall, image_path)
                except:
                    ALBUM_COVER_TO_SKIP.append(image_path)
                    return default_image_path
                else:
                    if res:
                        #Change resolution
                        try: pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(image_path,75,75)
                        except gobject.GError: return default_image_path
                        else:
                            if os.path.exists(image_path):
                                os.unlink(image_path)
                            pixbuf.save(image_path, "jpeg", {"quality":"85"})
                            del pixbuf
                            return image_path
                    else:
                        ALBUM_COVER_TO_SKIP.append(image_path)
                        return default_image_path






    """
        IPOD FUNCTION
    """

    def read_from_ipod_track(self,track,mount_point):

        def decode_tag(tag):
            if isinstance(tag, str):
                return tag.decode('utf-8', "replace")
            return tag
        self.set_property("ipod_track",track)
        self.set_property("ipod_id",track.id)
        self.set_property("title",decode_tag(track.title))
        self.set_property("album",decode_tag(track.album))
        self.set_property("artist",decode_tag(track.artist))
        self.set_property("duration",track.tracklen)
        self.set_property("genre",decode_tag(track.genre))

        if track.track_nr!=0:
            self.set_property("tracknr",track.track_nr)
        else:
            self.set_property("tracknr",None)
        file = gpod.itdb_filename_on_ipod(track)
        if file is not None:
            self.set_property("uri", "file://"+file)
        self.set_property("ipod_mount_point",mount_point)
        self.tagged=True



    def get_ipod_track(self ):
        file = self.get_path()
        if not os.path.exists(file):
            return None

        track = gpod.itdb_track_new()
        if self.sprint("title")!="": track.title = str(self.sprint("title"))
        #else: track.title = ""
        if not self.podcast and self.sprint("album")!="":
            track.album = str(self.sprint("album"))

        elif self.podcast and self.sprint("podcast_feed_title")!="":
            """ for podcast the album entry is the name of the feed """
            track.album = str(self.sprint("podcast_feed_title"))

        #else: track.album = ""
        if self.sprint("artist")!="": track.artist = str(self.sprint("artist"))
        #else: track.artist = ""
        if self.sprint("genre")!="": track.genre = str(self.sprint("genre"))
        """
        if self.sprint("genre") and self["genre"]!=None: track.genre = str(self["genre"])
        else: track.genre = "Rock"
        if self.sprint("comment") and self["comment"]!=None: track.comment = str(self["comment"])
        else: track.comment = ""
        if self.sprint("composer") and self["composer"]!=None: track.composer = str(self["composer"])
        else: track.composer = ""
        if self.sprint("grouping") and self["grouping"]!=None: track.grouping = str(self["grouping"])
        else: track.grouping = ""
        if self.sprint("category") and self["category"]!=None: track.category = str(self["category"])
        else: track.category = ""
        if self.sprint("description") and self["description"]!=None: track.description = str(self["description"])
        else: track.description = ""
        if self.has_key("subtitle") and self["subtitle"]!=None: track.subtitle = str(self["subtitle"])
        else: track.subtitle = ""

        track.cd_nr = long(0)
        track.cds = long(0)
        """

        if self.sprint("tracknr") !="" :
            track.track_nr = long(self.get_property("tracknr"))
        if self.sprint("duration") !="" :
             track.tracklen = long(self.get_property("duration"))


        """ podcast info """
        if self.podcast:
            track.podcasturl = str(self.uri)
            track.podcastrss = str(self.podcast_feed_uri)

        if self.sprint("bitrate") !="" : track.bitrate = long(self.get_property("bitrate"))


        if self.size !=None : track.size = long(self.size)


        """ For now i always use mp3 file """
        track.filetype = "MPEG audio file"
        track.time_added = long(utils.time_unix_to_mac(time()))
        track.time_modified = track.time_added


        art = self.get_album_cover(False)
        if os.path.exists(art):
            if gpod.itdb_track_set_thumbnails(track,str(art)) == 0:
                print "Failed to save image thumb for ",self.title

        return track




