###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


"""
import pygtk
pygtk.require("2.0")
import os, sys
import gobject
import gst
import time
import gtk
import stock
import xml.sax.saxutils
import locale
import gettext
import urllib
import config
from listen_db import DBManager
from listen_media_organizer import *
from listen_songview import *
from listen_widget import WindowBase
"""

class WidgetSongCDRom(gtk.VBox):
    def __init__(self,media_organizer,treeview_cdrom):
        gtk.VBox.__init__(self)

        self.treeview_cdrom = treeview_cdrom
        self.media_organizer = media_organizer



        hbox = gtk.HBox()
        self.set_spacing(6)
        hbox.pack_start(self.btn_extract,False,False)
        self.pack_start(scroll_treeview_cdrom,True,True)
        self.pack_start(hbox,False,False)


class TreeviewSongCDRom(TreeviewSong):
    def __init__(self,media_organizer,allow_column={"title":True,"album":True,"artist":True,"track":True,"duration":True}):

        TreeviewSong.__init__(self,media_organizer,allow_column)

        self.menu = self.get_menu()


        self.media_organizer = media_organizer
        """
        self.enable_model_drag_dest([("text/uri-list", 0, 0)], gtk.gdk.ACTION_COPY)
        self.connect("drag-data-received", self.on_drag_data_reveived)
        self.connect("key-press-event", self.on_key_press)"""


    def populate(self,info):
        self.set_model(None)
        self.model_song.clear()
        for item in info:
            self.model_song.append((item, int(item["tracknr"]),item["title"],int(item["duration"]),item["album"],item["artist"]))
            #print "Track %.02d: %s (%d)" % (i, read_info['TTITLE' + `i`],disc_id[i+2])

        self.set_model(self.model_song)

    def save_to_db(self):
        model, iter = self.media_organizer.get_selection().get_selected()
        if iter!=None:
            type = self.media_organizer.model.get_value(iter, 1)
            if type == type_donnees.PLAYLIST:
                item = self.media_organizer.model.get_value(iter, 0)
                id = item["playlist_id"]
                self.db.execute("DELETE FROM playlists WHERE id_playlist=%d;"%id)
                for row in self.model:
                    self.db.execute("""
                    INSERT INTO playlists (id_playlist,id_media,pos)
                    VALUES (
                             %d,%d,
                             (SELECT max(pos) FROM playlists WHERE id_playlist=%d)
                           );
                    """%(id,row[0]["id"],id))


    def get_menu(self):

        menu_ui = """
            <ui>
                <popup name="SongMenu">
                  <menuitem action="Play"/>
                  <menuitem action="Queue"/>
                  <separator/>
                  <menuitem action="Artist"/>
                  <menuitem action="Album"/>
                </popup>
            </ui>
            """

        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this song'), self.play_selected)])
        actiongroup.add_actions([('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this song'), self.enqueue_selected)])

        actiongroup.add_actions([('Artist', gtk.STOCK_ABOUT, _('About _artist'), None,
                                         _('More information about artist'), self.info_artist)])
        actiongroup.add_actions([('Album', gtk.STOCK_ABOUT, _('About a_lbum'), None,
                                         _('More information about album'), self.info_album)])




        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/SongMenu")

