###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###
import gtk

from view_browser import *
from view_song import TreeviewSong


class LocalLibraryBrowserView(BrowserView):

    def __init__(self,media_organizer):
        BrowserView.__init__(self,media_organizer,conf_prefix="local")

        self.set_song_treeview(TreeviewSong(media_organizer))
        self.treeviews["songs"].set_sort_by(None, _("Album"), gtk.SORT_ASCENDING, False)

        self.media_organizer.player.gst_player.connect("new-media",self.update_song)

    """ update new played song in the cache """
    def update_song(self,widget,song):
        if song in self.songs_cache:
            self.songs_cache[self.songs_cache.index(song)] = DBManager.get_song_by_id(song.id)


    def refresh_song_cache(self,DB=DBManager):
        """
        Warning DB parameter is only for boost startup
        If more than one DB used :
         you will have a sqlite thread problem
         OR a risk to desynchronize file with treeview and loose information
        """
        self.songs_cache = DB.get_all_songs()
        #self.songs_cache.sort()

