###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

from db_manager import *
from view_song import *

class TreeviewSongPlaylist(TreeviewSong):
    def __init__(self,media_organizer,allow_column={"title":True,"album":True,"artist":True,"track":True,"duration":True}):

        TreeviewSong.__init__(self,media_organizer,allow_column,False)

        self.menu = self.get_menu()


        self.media_organizer = media_organizer

        self.enable_model_drag_dest([("text/uri-list", 0, 0)], gtk.gdk.ACTION_COPY)
        self.connect("drag-data-received", self.on_drag_data_reveived)
        #self.connect("drag-data-get", self.on_drag_data_get)
        self.connect("key-press-event", self.on_key_press)

        self.current_playlist = None
        self.previous_current_playlist = None


    def on_drag_data_reveived(self,treeview, context, x, y, selection, info, timestamp):
        drop_info = treeview.get_dest_row_at_pos(x, y)
        model = treeview.get_model()
        #print selection.data
        if selection.target=="text/uri-list":
            if context.get_source_widget()==self:
                position = gtk.TREE_VIEW_DROP_AFTER
                model, rows = treeview.get_selection().get_selected_rows()
                if len(rows) < 1:
                    return
                rows = [row[0] for row in rows]

                if drop_info:
                    new_pos, position = drop_info
                    new_pos = new_pos[0]
                else:
                    new_pos = len(model)-1

                if new_pos < rows[0]:
                    rows.reverse()

                i=0
                for row in rows:
                    row += i
                    #print position
                    #print row," to ",new_pos
                    iter = model.get_iter(row)
                    is_current_item = model.get_value(iter,1)
                    new_iter = model.get_iter(new_pos)
                    if position == gtk.TREE_VIEW_DROP_BEFORE or position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE:
                        model.move_before(iter, new_iter);
                    if position == gtk.TREE_VIEW_DROP_AFTER or position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER:
                        model.move_after(iter, new_iter);
                    if new_pos < rows[0]:
                        i += 1
                    else:
                        i -= 1
            else :
                if drop_info:
                    new_pos, position = drop_info
                    new_pos = new_pos[0]
                    if position == gtk.TREE_VIEW_DROP_AFTER:
                        new_pos += 1
                else:
                    new_pos = len(model)

                #FIXME: ADD QUICK DRAG DROP
                #print "URIS ", selection.data
                self.set_model(None)
                for uri in selection.get_uris():
                    uri = urllib.unquote(uri)
                    #print "AJOUT DE " , uri ," A LA POS = ", new_pos
                    if 0<=new_pos and new_pos<len(model):
                        iter = self.model_song.get_iter(new_pos)
                        self.add(uri,new_pos)
                        new_pos+=1
                    else:
                        self.add(uri)
                        new_pos+=1

                self.set_model(self.model_song)
                while gtk.events_pending():gtk.main_iteration()

            self.save_to_db()
        return True



    def populate(self,id_playlist):
        self.current_playlist = id_playlist
        self.fill(DBManager.get_songs_from_playlist(id_playlist))

    def add(self,uri,pos=False):
        #print "pos",pos
        song = DBManager.get_song_by_uri(uri)
        if song == None or song.iradio:
            return False;
        if pos is False:
            self.songs_cache.append(song)
            #self.model_song.append(song.get_tuple_for_model_song())
            #self.model_song.append((song, song.get_int("tracknr"),song.sprint("title"),song.get_property("duration"),song.sprint("artist"),song.sprint("album")))
        else:
            self.songs_cache.insert(pos,song)
            #self.model_song.insert(pos,song.get_tuple_for_model_song())
            #self.model_song.insert(pos,(song, song.get_int("tracknr"),song.sprint("title"),song.get_property("duration"),song.sprint("artist"),song.sprint("album")))
        self.fill(self.songs_cache)
        return True

    def on_key_press(self, widget, event):
         if event.keyval == gtk.gdk.keyval_from_name("Delete"):
            self.remove_selected()
            return True

    def remove_selected(self,btn=None):
            model, rows = self.get_selection().get_selected_rows()
            rows.reverse()
            for row in rows:
                self.model_song.remove(self.model_song.get_iter(row))
            self.save_to_db()
            return True


    def save_to_db(self):
        DBManager.clear_playlist(self.current_playlist)
        songs = list([self.model_song[i][0] for i in range(0,len(self.model_song))])
        for song in songs:
            DBManager.add_song_to_playlist(song,self.current_playlist)


    def get_menu(self):

        menu_ui = """
            <ui>
                <popup name="SongMenu">
                  <menuitem action="Play"/>
                  <menuitem action="Queue"/>
                  <menuitem action="Remove"/>
                  <separator/>
                  <menuitem action="Lyrics"/>
                  <menuitem action="Artist"/>
                  <menuitem action="Album"/>
                  <separator/>
                  <menuitem action="Edit"/>
                </popup>
            </ui>
            """

        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this song'), self.play_selected)])
        actiongroup.add_actions([('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this song'), self.enqueue_selected)])
        actiongroup.add_actions([('Edit', gtk.STOCK_PROPERTIES, _('_Edit'), None,
                                         _('Edit this song'), self.edit_selected)])


        actiongroup.add_actions([('Remove', gtk.STOCK_REMOVE, _('_Remove'), None,
                          _('Remove this song'), self.remove_selected)])

        actiongroup.add_actions([('Artist', gtk.STOCK_ABOUT, _('About _artist'), None,
                                         _('More informations about this artist'), self.info_artist)])
        actiongroup.add_actions([('Album', gtk.STOCK_ABOUT, _('About a_lbum'), None,
                                         _('More informations about this album'), self.info_album)])
        actiongroup.add_actions([('Lyrics', gtk.STOCK_EDIT, _('See _Lyrics'), None,
                                         _('See lyrics'), self.info_lyrics)])




        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/SongMenu")

