###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gnomevfs
import gtk
import gobject
import pango
import traceback
#import xml.sax.saxutils

import config
import utils
from song_editor import SongEditor
from view_song import *
from db_manager import DBManager
from misc_widget import MultiDragTreeview

from view_browser import FailedRemoveSong

class TreeviewSong(MultiDragTreeview):
    def __init__(self,media_organizer,allow_column={"title":True,"album":True,"artist":True,"track":True,"duration":True},sortable=True):

        self.media_organizer = media_organizer
        self.player = media_organizer.player
        MultiDragTreeview.__init__(self)
        self.allow_column = allow_column
        self.sortable = sortable

        self.model_song = gtk.ListStore(object,gobject.TYPE_INT,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING)#donnees, chaine de trie

        self.renderer_song = gtk.CellRendererText()
        self.renderer_song.set_property("ellipsize",pango.ELLIPSIZE_END)
        self.renderer_song_artist = gtk.CellRendererText()
        self.renderer_song_artist.set_property("ellipsize",pango.ELLIPSIZE_END)
        self.renderer_song_album = gtk.CellRendererText()
        self.renderer_song_album.set_property("ellipsize",pango.ELLIPSIZE_END)
        self.renderer_song_duration = gtk.CellRendererText()
        self.renderer_song_track = gtk.CellRendererText()
        self.songs_cache=[]


     ### song

        column_song = gtk.TreeViewColumn(_("Title"),self.renderer_song,text=2)
        column_song.set_expand(True)
        if sortable:
            column_song.connect('clicked', self.set_sort_by)
            column_song.set_reorderable(True)
            column_song.set_clickable(True)
        column_song.set_sizing(gtk.TREE_VIEW_COLUMN_GROW_ONLY)

        column_song_album = gtk.TreeViewColumn(_("Album"),self.renderer_song_album,text=4)
        column_song_album.set_min_width(100)
        if sortable:
            column_song_album.connect('clicked', self.set_sort_by)
            column_song_album.set_reorderable(True)
            column_song_album.set_clickable(True)
        column_song_album.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)


        column_song_artist = gtk.TreeViewColumn(_("Artist"),self.renderer_song_artist,text=5)
        if sortable:
            column_song_artist.set_clickable(True)
            column_song_artist.connect('clicked', self.set_sort_by)
            column_song_artist.set_reorderable(True)
        column_song_artist.set_min_width(100)
        column_song_artist.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)


        column_song_duration = gtk.TreeViewColumn(_("Length"),self.renderer_song_duration,text=3)
        if sortable:
            column_song_duration.connect('clicked', self.set_sort_by)
            column_song_duration.set_reorderable(True)
            column_song_duration.set_clickable(True)

        column_song_track = gtk.TreeViewColumn("#",self.renderer_song_track,text=6)
        if sortable:
            column_song_track.connect('clicked', self.set_sort_by)
            column_song_track.set_reorderable(True)
            column_song_track.set_clickable(True)
        column_song_track.set_fixed_width(30)

        self.append_column(column_song_track)
        self.append_column(column_song)
        self.append_column(column_song_duration)
        self.append_column(column_song_album)
        self.append_column(column_song_artist)

        self.set_visible_column()

        targets = [("text/uri-list", 0, 0)]
        self.drag_source_set(
            gtk.gdk.BUTTON1_MASK, targets,
            gtk.gdk.ACTION_COPY)
        #self.enable_model_drag_dest(targets, gtk.gdk.ACTION_DEFAULT|gtk.gdk.ACTION_COPY)
        """self.enable_model_drag_source(
            gtk.gdk.BUTTON1_MASK|gtk.gdk.SHIFT_MASK|gtk.gdk.CONTROL_MASK, targets,
            gtk.gdk.ACTION_COPY)"""

        self.set_rules_hint(True)


        self.connect("row-activated", self.on_row_song_activated)
        self.connect("drag-data-get", self.on_song_drag_data_get)
        self.connect("popup-menu",self.__popup_menu)

        self.set_search_equal_func(self.on_song_search)
        self.get_selection().set_mode(gtk.SELECTION_MULTIPLE)

        self.menu = self.get_menu()
        self.__sig = None
        self.filter = []
        self.set_model(self.model_song)

    """""""""""""""""""""""""""
        FUNC ACTION
    """""""""""""""""""""""""""
    def stop_fill(self):
        self.model_song.clear()
        if self.__sig!=None : gobject.source_remove(self.__sig)

    def fill(self,songs):
        self.songs_cache = songs
        if self.sortable:
            self.set_songs(songs)
        else:
            if self.__sig!=None : gobject.source_remove(self.__sig)
            self.get_toplevel().window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
            self.set_model(None)
            self.model_song.clear()
            songs = [song.get_tuple_for_model_song() for song in songs]
            self.__sig = gobject.idle_add(self.__idle_add,songs)

    def __idle_add(self,songs_to_add,title=_("Album"),order=False):
        if self.__sig!=None : gobject.source_remove(self.__sig)
        songs = songs_to_add[:100]
        for song_tuple in songs:
            self.model_song.append(song_tuple)
        if len(songs_to_add[100:])>0:
            self.__sig = gobject.idle_add(self.__idle_add,songs_to_add[100:],title,order)
        else:
            self.set_model(self.model_song)
            self.set_sort_by(None,title,order=order,refresh=False)
            self.get_toplevel().window.set_cursor(None)

    """ Quodlibet grab """
    def get_sort_by(self):
        for header in self.get_columns():
            if header.get_sort_indicator():
                return (header.get_title(),
                        header.get_sort_order() == gtk.SORT_DESCENDING)
        else: return _("Album"), False

    def is_sorted(self):
        return max([col.get_sort_indicator() for col in self.get_columns()])

    def set_sort_by(self, header, title=None, order=None, refresh=True):
        if header!=None and title==None: title = header.get_title()

        for h in self.get_columns():
            if h.get_title() == title:
                if order is None:
                    s = header.get_sort_order()
                    if (not header.get_sort_indicator() or
                        s == gtk.SORT_DESCENDING):
                        s = gtk.SORT_ASCENDING
                    else: s = gtk.SORT_DESCENDING
                else:
                    if order: s = gtk.SORT_DESCENDING
                    else: s = gtk.SORT_ASCENDING
                h.set_sort_indicator(True)
                h.set_sort_order(s)
            else: h.set_sort_indicator(False)
        if refresh:
            self.set_songs(self.songs_cache)

    def get_tag_by_title(self,title):
        if title == _("Album"): tag = "album"
        elif title == _("Length"): tag = "duration"
        elif title ==  _("Artist"): tag = "artist"
        elif title ==  _("Title"): tag = "title"
        elif title == "#": tag = "tracknr"
        return tag

    def set_songs(self, songs):
        title, reverse = self.get_sort_by()
        tag = self.get_tag_by_title(title)
        songs = [(song.get_property(tag), song.sort_key, song) for song in songs]
        songs.sort()
        if reverse: songs.reverse()
        songs = [song[2].get_tuple_for_model_song() for song in songs]

        if self.__sig!=None : gobject.source_remove(self.__sig)
        self.get_toplevel().window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
        self.set_model(None)
        self.model_song.clear()
        self.__sig = gobject.idle_add(self.__idle_add,songs,title, reverse)
    """ Quodlibet grab END"""

    def set_visible_column(self):
        list_col = ["track","title","duration","album","artist"]
        for index,col in enumerate(list_col):
            if self.allow_column.has_key(col) and self.allow_column[col] and config.get("songview",col)=="1":
                self.get_column(index).set_visible(True)
            else:
                self.get_column(index).set_visible(False)


    def remove_selected(self,btn=None,disk_remove=False):
        model, rows = self.get_selection().get_selected_rows()
        if len(rows) < 1:
            return

        browser = None
        from media_source import MLBrowserSource
        for source in self.media_organizer.list_source:
            if isinstance(source,MLBrowserSource):
                browser = source.widget

        rows.reverse()
        songs_to_remove = []
        for row in rows:
            song = model[row][0]

            if disk_remove:
                if not utils.move_to_trash(song.get_path()):
                    print "Failed move",song.get_path(),"to the trash folder"

            DBManager.delete_song(song)
            del model[row]
            songs_to_remove.append(song)

        browser.remove_songs(songs_to_remove)

    def remove_selected_disk(self,btn=None):
        self.remove_selected(None,True)

    def edit_selected(self,btn=None):
        model, rows = self.get_selection().get_selected_rows()
        if len(rows) < 1:
            return
        list_song = list([model.get_value(model.get_iter(row), 0) for row in rows])
        window = SongEditor(self.get_toplevel(),list_song)

    def play_selected(self,btn=None):
        model, rows = self.get_selection().get_selected_rows()
        if len(rows) < 1:
            return
        play = True
        for iter in rows:
            song = model.get_value(model.get_iter(iter), 0)
            self.player.playlist.add_song(song,False,play)
            play = False
        #print pos

    def enqueue_selected(self,btn=None):
        model, rows = self.get_selection().get_selected_rows()
        if len(rows) < 1:
            return

        for iter in rows:
            song = model.get_value(model.get_iter(iter), 0)
            self.player.playlist.add_song(song)

    def info_artist(self,btn=None):
        model, rows = self.get_selection().get_selected_rows()
        song = model.get_value(model.get_iter(rows[0][0]),0)

        from media_source import ContextWikipediaSource
        for source in self.media_organizer.list_source:
            if isinstance(source,ContextWikipediaSource):
                source.widget.set_action("artist")
                source.widget.new_media_cb(None,song)
                self.media_organizer.select_source(source)
                #self.media_organizer.unselect()

    def info_album(self,btn=None):
        model, rows = self.get_selection().get_selected_rows()
        song = model.get_value(model.get_iter(rows[0][0]),0)

        from media_source import ContextWikipediaSource
        for source in self.media_organizer.list_source:
            if isinstance(source,ContextWikipediaSource):
                source.widget.set_action("album")
                source.widget.new_media_cb(None,song)
                self.media_organizer.select_source(source)
                #self.media_organizer.unselect()


    def info_lyrics(self,btn=None):
        model, rows = self.get_selection().get_selected_rows()
        song = model.get_value(model.get_iter(rows[0][0]),0)
        from media_source import ContextLyricsSource
        for source in self.media_organizer.list_source:
            if isinstance(source,ContextLyricsSource):
                source.widget.new_media_cb(None,song)
                self.media_organizer.select_source(source)
                #self.media_organizer.unselect()




    """""""""""""""""""""""""""
        FUNC SELECTION
    """""""""""""""""""""""""""
    def on_row_song_activated(self, treeview, path, view_column):
        self.play_selected()

    def __popup_menu(self,widget):
        self.menu.popup(None,None,None,0,gtk.get_current_event_time())


    """""""""""""""""""""""
        CELL RENDER FUNC
    """""""""""""""""""""""
    """def __cell_data_func_song(self, column, cell, model, iter):
        title = column.get_title()
        if title == _("Title"):
            value = model.get_value(iter, 2)
            if value=="":
                value = model.get_value(iter, 0)
                value = "("+value.get_property("uri")+")"
        elif title == _("Artist"):
             value = model.get_value(iter, 4)
        elif title == _("Album")  :
             value = model.get_value(iter, 5)
        elif title == _("Length") :
             value = model.get_value(iter, 3)
             value  = utils.duration_to_string(value)
        elif title == "#" :
             value = model.get_value(iter, 1)
             if value == 0:
                 value = ""
             else:
                 value = "%d"%value
        else:
             value = ""
        value = utils.xmlescape(value)
        if config.get("setting","mlib_smallfont")=="true":
            value="<span size=\"small\">"+value+"</span>"
        #print "TITLE: ",title," - VALEUR: ",value
        cell.set_property("markup",value )"""


    """""""""""""""""""""
        FUNC FILTER
    """""""""""""""""""""
    def on_song_search(self,model, column, key, iterator):
        title = model.get_value(iterator, 0).sprint("title")
        if title.lower().find(key.lower()) == 0:
          return False
        return True


    """""""""""""""""""""
        FUNC DRAG DROP
    """""""""""""""""""""
    def on_song_drag_data_get(self,treeview, context, selection, info, timestamp):
        #print "SONG VIEW : drop data get"
        model, rows = self.get_selection().get_selected_rows()

        list_uri = []
        list_song = []
        for row in rows:
            song = model.get_value(model.get_iter(row[0]),0)
            list_song.append(song)
            uri = song.get_property("uri")
            uri = utils.convert_to_uri(uri)
            list_uri.append(uri)

        self.get_toplevel().last_drag_drop = list_song
        selection.set_uris(list_uri)


    def get_menu_ui(self):
        return """
            <ui>
                <popup name="SongMenu">
                  <menuitem action="Play"/>
                  <menuitem action="Queue"/>
                  <menuitem action="DeleteLibrary"/>
                  <separator/>
                  <menuitem action="DeleteDisk"/>
                  <separator/>
                  <menuitem action="Lyrics"/>
                  <menuitem action="Artist"/>
                  <menuitem action="Album"/>
                  <separator/>
                  <menuitem action="Edit"/>
                </popup>
            </ui>
            """

    def get_menu(self):

        menu_ui = self.get_menu_ui()

        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')

        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this song'), self.play_selected),
                                 ('Queue', gtk.STOCK_ADD, _('_Queue'), None,
                                         _('Queue this song'), self.enqueue_selected),
                                 ('Edit', gtk.STOCK_PROPERTIES, _('_Edit'), None,
                                         _('Edit this song'), self.edit_selected),
                                 ('DeleteLibrary', gtk.STOCK_REMOVE, _('Remove'), None,
                                         _('Remove this song from the library'), self.remove_selected),
                                 ('DeleteDisk', gtk.STOCK_DELETE, _('Move to trash'), None,
                                         _('Move this song to the trash'), self.remove_selected_disk),
                                 ('Artist', gtk.STOCK_ABOUT, _('About _artist'), None,
                                         _('More informations about this artist'), self.info_artist),
                                 ('Album', gtk.STOCK_ABOUT, _('About a_lbum'), None,
                                         _('More informations about this album'), self.info_album),
                                 ('Lyrics', gtk.STOCK_EDIT, _('See _Lyrics'), None,
                                         _('See lyrics'), self.info_lyrics)])


        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/SongMenu")

