###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
import gobject
import gtkhtml2
import urllib
from xml.dom import minidom
import xml.sax.saxutils
import re
#import threading
import pango

import config
import stock
import utils
import random
from web_manager import *
from misc_widget import get_scrolled_window
from db_manager import DBManager
from thread_queue import ThreadQueue


LEOLYRICS_AUTH = "listen"
WIKI_HOTE = "%s.wikipedia.org"
WIKI_URL = WIKI_HOTE+"/wiki/"

class ListenWikiPedia(gtk.VBox):
    def __init__(self,media_organizer):
        gtk.VBox.__init__(self,False,6)
        #self.set_border_width(6)
        self.player = media_organizer.player
        self.player.gst_player.connect("new-media",self.new_media_cb)

        self.last_action = "artist"
        self.song = None
        self.url_back = []
        self.url_forward = []
        self.current_url = None

        self.document_wiki = HTMLDocument()
        self.document_wiki.connect('link_clicked', self.link_clicked)

        self.document_info = HTMLDocument()
        self.document_info.connect('link_clicked', self.link_clicked)

        HTML_PRESENTATION = get_template()%("""
            """)
        self.document_info.open_stream('text/html')
        self.document_info.write_stream(HTML_PRESENTATION)
        self.document_info.close_stream()


        self.view = gtkhtml2.View()
        self.view.set_document(self.document_info)
        self.view.set_magnification(1)

        self.btn_forward = self.make_btn(gtk.STOCK_GO_FORWARD,"forward")
        utils.set_tip(self.btn_forward,_("Forward"))
        self.btn_back = self.make_btn(gtk.STOCK_GO_BACK,"back")
        utils.set_tip(self.btn_back,_("Back"))
        self.btn_artist = self.make_btn(stock.WIKI_USERS,"artist",_("Artist"))
        self.btn_artist.set_active(True)
        self.btn_album = self.make_btn(stock.WIKI_CD,"album",_("Album"),self.btn_artist)
        self.btn_title = self.make_btn(gtk.STOCK_DIALOG_INFO,"title",_("Song")+"   ",self.btn_artist)

        self.btn_browser = gtk.Button()
        self.btn_browser.add(gtk.image_new_from_icon_name("stock_internet", gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_browser.connect("clicked",self.open_in_browser)
        utils.set_tip(self.btn_browser,_("See in web browser"))

        model = gtk.ListStore(gobject.TYPE_STRING)

        self.dropdown_lang = gtk.combo_box_new_text()
        langs = ["en","fr","de","es","it","nl","sv","pl","pt"]
        for lang in langs:
            if lang == config.get("setting","wikipedia"):
                active = langs.index(lang)
                self.lang=lang
            self.dropdown_lang.append_text(lang)

        self.dropdown_lang.set_active(active)
        self.dropdown_lang.connect("changed",self.on_change_lang)
        utils.set_tip(self.dropdown_lang,_("Change wikipedia language"))

        self.update_btn_status()

        hbox = gtk.HBox(False,6)

        hbox.pack_start(self.btn_artist,False,False)
        hbox.pack_start(self.btn_album,False,False)
        hbox.pack_start(self.btn_title,True,True)
        hbox.pack_start(self.btn_browser,False,False)
        hbox.pack_start(self.btn_back,False,False)
        hbox.pack_start(self.btn_forward,False,False)
        hbox.pack_start(self.dropdown_lang,False,False)

        self.pack_start(hbox,False,False)
        self.pack_start(get_scrolled_window(self.view))
        self.site_cache={}

        self.thread_id = None

    def open_in_browser(self,btn=None):
        if self.current_url!=None:
            utils.website(self.current_url);

    #While i search how to fix segmentation fault
    #(Due when to stream in the same document)
    #For now i create 1 doc / stream(page)
    def get_new_document(self):
        document = HTMLDocument()
        document.connect('link_clicked', self.link_clicked)
        document.set_base_uri("http://"+WIKI_HOTE%self.lang+"/")
        return document

    def on_change_lang(self,widget):
        self.lang = self.dropdown_lang.get_active_text()
        config.set("setting","wikipedia",self.lang)
        self.fetch_information(None,self.last_action)

    def set_action(self,action):
        if action=="artist":
            self.btn_artist.connect("clicked",lambda x: None)
            self.btn_artist.clicked()
            self.btn_artist.connect("clicked",self.fetch_information,action)
        if action=="album":
            self.btn_album.connect("clicked",lambda x: None)
            self.btn_album.clicked()
            self.btn_album.connect("clicked",self.fetch_information,action)
        if action=="title":
            self.btn_title.connect("clicked",lambda x: None)
            self.btn_title.clicked()
            self.btn_title.connect("clicked",self.fetch_information,action)


    def make_btn(self,stocks,action,label=None,btn=None):
        if label==None:
           btn = gtk.Button()
           image = gtk.image_new_from_stock(stocks, gtk.ICON_SIZE_BUTTON)
           btn.add(image)
        else:
           btn = gtk.RadioButton(group=btn)
           image = gtk.image_new_from_stock(stocks, gtk.ICON_SIZE_BUTTON)
           label = gtk.Label(label)
           label.set_alignment(0,0.5)
           box = gtk.HBox(False,6)
           box.pack_start(image,False,False)
           box.pack_start(label,True,True)
           btn.add(box)


        btn.connect("clicked",self.fetch_information,action)
        return btn

    def new_media_cb(self,widget,song):
        if song==None:
            return
        self.song = song
        if song.podcast:
            self.document_info.clear()
            self.document_info.open_stream('text/html')
            HTML = get_template()%("<h3>"+_("Wikipedia not available for this media type")+"</h3>")
            self.document_info.write_stream(HTML)
            self.document_info.close_stream()
            self.view.set_document(self.document_info)
        else:
            self.fetch_information(None,self.last_action)

    def update_btn_status(self):
        if len(self.url_back)==0:
            self.btn_back.set_sensitive(False)
        else:
            self.btn_back.set_sensitive(True)
        if len(self.url_forward)==0:
            self.btn_forward.set_sensitive(False)
        else:
            self.btn_forward.set_sensitive(True)

    def fetch_information(self,btn,action):

        if action in ["artist","album","title"]:
            self.last_action=action
            if self.song==None:
                return
            url = "http://"+(WIKI_URL%self.lang)+urllib.quote(self.song.sprint(action).encode("utf-8"))
            if str(url) == str(self.current_url):
                return

            self.document_info.clear()
            self.document_info.open_stream('text/html')
            msg =  _("Fetching informations from")+" <b>\""+(WIKI_HOTE%self.lang)+"\"</b>"
            HTML = get_template()%("<h3>"+msg.encode("utf-8")+"<br>"+_("About ")+" <b>\"%s\"</b></h3>"%self.song.sprint(action))
            self.document_info.write_stream(HTML)
            self.document_info.close_stream()
            self.view.set_document(self.document_info)

            clear_forward = True
            update_nav = True

        elif action=="back":
            #Ecrire un tableau de lien des
            url = self.url_back.pop()
            if self.current_url !=None:
                self.url_forward.append(self.current_url)
            clear_forward = False
            update_nav = False

        elif action=="forward":
            url = self.url_forward.pop()
            clear_forward = False
            update_nav = True

        if action not in ["artist","album","title"]:
            self.document_info.clear()
            """self.document_info.open_stream('text/html')
            msg =  _("Fetching ")+" <b>\""+url+"\"</b>"
            HTML = get_template()%("<h3>"+msg.encode("utf-8")+"</h3>")
            self.document_info.write_stream(HTML)
            self.document_info.close_stream()"""
            self.view.set_document(self.document_info)

        self.link_clicked(self.get_new_document(),url,clear_forward,update_nav)

    def link_clicked(self,document, link,clear_forward=True,update_nav=True):
        ThreadQueue.remove_task(self.thread_id)
        self.thread_id = ThreadQueue.add_task(self.__link_clicked,document,link,clear_forward,update_nav)

    def __link_clicked(self,document, link,clear_forward=True,update_nav=True):
        if str(link) == str(self.current_url):
            return
        if clear_forward:
            self.url_forward = []
        if self.current_url !=None and update_nav:
            self.url_back.append(self.current_url)

        if self.site_cache.has_key(link):
            html = self.site_cache[link]
        else:
            f = document.open_url(link)
            if f==None:
                self.document_info.clear()
                self.document_info.open_stream('text/html')
                msg =  _("Informations from")+" <b>\""+(WIKI_HOTE%self.lang)+"\"</b>"
                HTML = get_template()%("<h3>"+msg.encode("utf-8")+_(" not found"))
                self.document_info.write_stream(HTML)
                self.document_info.close_stream()
                #self.view.set_document(self.document_info)
                gobject.idle_add(self.view.set_document,self.document_info)


                return

            gobject.idle_add(self.update_btn_status)
            document.clear()
            headers = f.info()
            mime = headers.getheader('Content-type')
            if mime:
                document.open_stream(mime)
            else:
                document.open_stream('text/plain')
            html = f.read()
            html = html[html.find("<body"):html.find("</body>")]
            #html = re.sub('<(.*)>', "", html)
            html = re.sub("class=\"(.[^>]*)\"","",html)
            html = re.sub("id=\"(.[^>]*)\"","",html)
            html = re.sub("style=\"(.[^>]*)\"","",html)
            #html = re.sub("<input(.[^>]*)>","",html)
            #print html

            html = get_template()%html

        self.site_cache[link] = html
        self.current_url = link#document.resolve_uri(link)

        document.open_stream('text/html')
        import libxml2

        #deactivate error messages from the validation
        def noerr(ctx, str):
            pass

        libxml2.registerErrorHandler(noerr, None)

        ctxt = libxml2.createDocParserCtxt(html)
        ctxt.validate(1)
        ctxt.parseDocument()
        doc = ctxt.doc()
        valid = ctxt.isValid()
        doc.freeDoc()
        if valid != 0:
            print "validity check failed"
            html = _("Retrieve information failed.")
        document.write_stream(html)
        document.close_stream()
        gobject.idle_add(self.view.set_document,document)




class ListenLyrics(gtk.VBox):
    def __init__(self,media_organizer):
        gtk.VBox.__init__(self,False,0)
        self.media_organizer = media_organizer

        self.song = None

        self.document_info = HTMLDocument()

        self.media_organizer.player.gst_player.connect("new-media",self.new_media_cb)

        HTML_PRESENTATION = get_template()%("")

        self.document_info.clear()
        self.document_info.open_stream('text/html')
        self.document_info.write_stream(HTML_PRESENTATION)
        self.document_info.close_stream()


        self.view = gtkhtml2.View()
        self.view.set_document(self.document_info)
        self.view.set_magnification(1)


        self.pack_start(get_scrolled_window(self.view))
        self.thread_id = None


    def new_media_cb(self,widget,song):
        if song==None:
            return
        self.song = song
        if self.song.podcast:
            self.set_html("<h3>"+_("Lyrics not available for this media type")+"</h3>")
        else:
            self.set_html("<h3>"+_("Fetching lyrics for")+" <b>"+song.sprint("title")+"</b></h3>")
            ThreadQueue.remove_task(self.thread_id)
            self.thread_id = ThreadQueue.add_task(self.fetch_lyrics)


    def fetch_lyrics(self):
    # Leolyrics API reader grab on lyrics.py from quodlibet Copyright 2005 Eduardo Gonzalez, Joe Wreschnig
        artist = self.song.sprint("artist").encode("utf-8")
        title = self.song.sprint("title").encode("utf-8")
        self.songlist = []
        try:
            """http://api.leoslyrics.com/api_search.php?auth=listen&artist=muse&songtitle=sunburn"""
            sock = urllib.urlopen(
                "http://api.leoslyrics.com/api_search.php?auth="
                "%s&artist=%s&songtitle=%s"%(
        LEOLYRICS_AUTH,
                urllib.quote(artist.encode('utf-8')),
                urllib.quote(title.encode('utf-8'))))
            #print sock
            xmldoc = minidom.parse(sock).documentElement
        except:
            gobject.idle_add(self.set_html, _("<p>Server did not respond.</p>"))
            return

        sock.close()
        result_code = xmldoc.getElementsByTagName(
            'response')[0].getAttribute('code')
        #print "Result code: ", result_code
        if result_code == '0': #success
            # This is 0 even if there are no matches.

            # We don't really need the top 100 matches, so I'm limiting it to ten
            matches = xmldoc.getElementsByTagName('result')[:10]
            songs = map(lambda x:
                        x.getElementsByTagName('name')[0].firstChild.nodeValue
            + " - " +
            x.getElementsByTagName('title')[0].firstChild.nodeValue,
            matches)
            hids = map(lambda x: x.getAttribute('hid'), matches)
            exacts = map(lambda x: x.getAttribute('exactMatch'), matches)
            #print "->>"
            #print hids
            #print exacts
            if len(hids) == 0:
                #FIXME show other matches
                gobject.idle_add(self.set_html, '<p>Unable to find any ' +
                                 'matches for this song.</p>')
                return

            for i in range(len(hids)):
                self.songlist.append((songs[i], hids[i], exacts[i]))

            xmldoc.unlink()

            # Show the first match
            try:
                sock = urllib.urlopen(
                    "http://api.leoslyrics.com/api_lyrics.php?auth="
                    "%s&hid=%s"%(
                    LEOLYRICS_AUTH,
                    urllib.quote(self.songlist[0][1].encode('utf-8'))))
                xmldoc = minidom.parse(sock).documentElement
            except:
                gobject.idle_add(self.set_html,
                                 "<p>Unable to get the lyrics. " +
                                 "Please try again later.</p>")
                return
            sock.close()

            text = "<h1>"+self.decode(xmldoc.getElementsByTagName('title')[0].firstChild.nodeValue)
            text += ' - ' + self.decode(xmldoc.getElementsByTagName('artist')[0].getElementsByTagName('name')[0].firstChild.nodeValue) +"</h1>"
            text += "<p>&nbsp;</p><p>"+self.decode(xmldoc.getElementsByTagName('text')[0].firstChild.nodeValue).replace("\n","</p><p>")+"</p>"
            xmldoc.unlink()

            text += "<p>&nbsp;</p><p><i>Lyrics provided by leoslyrics.com</i></p>"
            #print text
            gobject.idle_add(self.set_html, text)

        else: #failed
            gobject.idle_add(self.set_html, "<p>Server busy, try again later.</p>")
            xmldoc.unlink()
            return

    def decode(self,text):
        """print text.decode("utf-8")
        #print text
        text = unicode(text)
        text = text.encode('iso-8859-1')
        for codec in ['utf-8','iso-8859-1']:
            try: text = text.decode(codec)
            except (UnicodeError, LookupError): pass
            else:break
        else: return None
        return text.encode("utf-8")"""
        return unicode(text.decode("utf-8"))
    def set_html(self,html):
        self.document_info.clear()

        html = get_template()%(html)

        self.document_info.open_stream('text/html')
        self.document_info.write_stream(html)
        self.document_info.close_stream()





class ListenLastFmService(gtk.VBox):
    def __init__(self,media_organizer):
        gtk.VBox.__init__(self,False,6)
        self.media_organizer = media_organizer

        self.song = None
        self.media_organizer.player.gst_player.connect("new-media",self.new_media_cb)
        self.label = gtk.Label()
        self.label.set_use_markup(True)
        self.label.set_markup("<span size=\"large\"><b>"+_("Last.fm - Similar artists")+"</b></span>")
        self.label.set_alignment(0,0.5)
        self.label.set_size_request(-1,22)
        logo = gtk.Image()
        logo.set_from_file(config.PIXMAP_DIR+"lastfm.png")
        logo.set_alignment(1,0.5)
        label_box = gtk.HBox(False,6)
        label_box.pack_start(gtk.Arrow(gtk.ARROW_RIGHT,gtk.SHADOW_NONE),False,False)
        label_box.pack_start(self.label,True,True)


        self.label_error = gtk.Label(_("No information available"))
        self.label_error.set_alignment(0.1,0.5)
        self.label_wait = gtk.Label(_("Fetching informations"))
        self.label_wait.set_alignment(0.1,0.5)

        #self.artists_box = gtk.VBox()
        self.artists_box = gtk.Table(1,1)
        self.artists_box.attach(self.label_error, 0, 1, 0, 1)

        self.btn_more = gtk.Button()
        btn_label = gtk.Label()
        btn_label.set_markup("<span color=\"blue\"><u>"+_("More similar artists")+"</u></span>")
        self.btn_more.add(btn_label)
        self.btn_more.connect("clicked",lambda widget:utils.website("http://www.last.fm/music/%s/+similar"%utils.filter_info_song(self.song.sprint("artist")).encode("utf-8")))
        self.btn_more.set_relief(gtk.RELIEF_NONE)

        bottom_box = gtk.HBox()
        bottom_box.pack_start(self.btn_more,False,False)
        bottom_box.pack_end(logo,False,False)

        self.pack_start(label_box,False,False)
        self.pack_start(self.artists_box,False,False)
        self.pack_end(bottom_box,False,False)

        self.last_artist=None
        self.thread_id = None
        self.__id_dynamic = None
        self.current_artists_name = {}
        self.blacklist_songs = []

    def new_media_cb(self,widget,song):
        if song==None:
            return
        if song.podcast:
            self.artists_box.foreach(self.artists_box.remove)
            self.artists_box.resize(1,1)
            self.artists_box.attach(self.label_error, 0, 1, 0, 1)
        else:
            if self.last_artist==song.sprint("artist"):
                if self.__id_dynamic!=None: gobject.source_remove(self.__id_dynamic)
                self.__id_dynamic = gobject.idle_add(self.add_dynamic_track)
                return
            self.btn_more.hide()

            self.last_artist = song.sprint("artist")
            self.song = song
            self.artists_box.foreach(self.artists_box.remove)
            self.artists_box.resize(1,1)
            self.artists_box.attach(self.label_wait, 0, 1, 0, 1)
            self.artists_box.show_all()
            #while gtk.events_pending():gtk.main_iteration()
            ThreadQueue.remove_task(self.thread_id)
            if self.current_artists_name.has_key(self.last_artist) and len(self.current_artists_name[self.last_artist])<=0:

                if self.__id_dynamic!=None: gobject.source_remove(self.__id_dynamic)
                self.__id_dynamic = gobject.idle_add(self.add_dynamic_track)

                self.thread_id = ThreadQueue.add_task(self.fetch_info,False)
            else:
                self.thread_id = ThreadQueue.add_task(self.fetch_info,True)


    def fetch_info(self,fill_dynamic_playlist=True):

        artist = utils.filter_info_song(self.last_artist).encode("utf-8")
        self.songlist = []
        try:
            url = "http://ws.audioscrobbler.com/1.0/artist/%s/similar.xml"%urllib.quote(artist)
            #print url
            sock = urllib.urlopen(url)
            xmldoc = minidom.parse(sock).documentElement
        except:
            gobject.idle_add(self.artists_box.foreach,self.artists_box.remove)
            gobject.idle_add(self.artists_box.resize,1,1)
            gobject.idle_add(self.artists_box.attach,self.label_error, 0, 1, 0, 1)

            #gobject.idle_add(self.artists_box.pack_start,self.label_error,False,False)
            #print "Not found"
            return

        sock.close()
        full_artists = xmldoc.getElementsByTagName("artist")
        self.current_artists_name[self.last_artist] = []
        for artist in full_artists[:50]:
            artist_name = artist.getElementsByTagName("name")[0].firstChild.nodeValue
            self.current_artists_name[self.last_artist].append(artist_name)

        artists = full_artists[:16]
        if len(artists)<=0:
            gobject.idle_add(self.artists_box.foreach,self.artists_box.remove)
            gobject.idle_add(self.artists_box.resize,1,1)
            gobject.idle_add(self.artists_box.attach,self.label_error, 0, 1, 0, 1)
            return
        #print artists
        list_btn = []
        for artist in artists:
            artist_name = artist.getElementsByTagName("name")[0].firstChild.nodeValue
            artist_url = artist.getElementsByTagName("url")[0].firstChild.nodeValue
            artist_match = artist.getElementsByTagName("match")[0].firstChild.nodeValue
            artist_image = artist.getElementsByTagName("image_small")[0].firstChild.nodeValue
            list_btn.append(self.make_btn_artist(artist_name,artist_url,artist_match,artist_image))
        #print list_btn

        i = 0
        height= int(round(len(list_btn)/2,1))
        if len(list_btn)%2!=0: height += 1
        if height>8 : height=8
        gobject.idle_add(self.artists_box.resize,height,2)
        top_attach = 0
        left_attach = 0
        gobject.idle_add(self.artists_box.foreach,self.artists_box.remove)
        for btn in list_btn:
            right_attach = left_attach+1
            bottom_attach = top_attach+1
            gobject.idle_add(self.artists_box.attach,btn, left_attach, right_attach, top_attach, bottom_attach)
            i += 1
            if i%height==0:
                left_attach += 1
                top_attach = 0
            else:
                top_attach += 1

            #gobject.idle_add(self.artists_box.pack_start,btn,False,False)
        if len(list_btn)>0:
            gobject.idle_add(self.btn_more.show)
        gobject.idle_add(self.artists_box.show_all)

        if fill_dynamic_playlist:
            if self.__id_dynamic!=None: gobject.source_remove(self.__id_dynamic)
            self.__id_dynamic = gobject.idle_add(self.add_dynamic_track)
        xmldoc.unlink()
        return

    def add_dynamic_track(self):
        if config.get("player","dynamic")=="true" and self.current_artists_name.has_key(self.last_artist) and len(self.current_artists_name[self.last_artist])>0:

            from media_source import MLBrowserSource
            for source in self.media_organizer.list_source:
                if isinstance(source,MLBrowserSource):
                    songs = source.widget.songs_cache

                    songs = filter(lambda song : song.get_property("artist") in self.current_artists_name[self.last_artist],songs)
                    current_song = [row[0] for row in self.media_organizer.player.playlist.model]


                    def get_random_song(songs,nb):
                        songs = filter(lambda song : song not in current_song,songs)
                        songs = filter(lambda song : song not in self.blacklist_songs,songs)

                        random.shuffle(songs)

                        artists = {}
                        for song in songs:
                            artists[song.get_property("artist")]=song

                        songs = [(song.get_property("playcount"), song) for artist,song in artists.iteritems()]

                        songs = songs[:50]
                        songs.sort()
                        songs = songs[:nb]
                        songs = [song[1] for song in songs]
                        return songs

                    songs = get_random_song(songs,5)
                    while len(songs)<5:
                        tmp_songs = get_random_song(source.widget.songs_cache,5-len(songs))
                        songs.extend(tmp_songs)
                    print len(songs)
                    if len(songs)>1:
                        if self.media_organizer.player.playlist.current_item >= 5:
                            for i in range(0,self.media_organizer.player.playlist.current_item):
                                self.media_organizer.player.playlist.remove((0,))
                        nb = 0
                        if len(self.media_organizer.player.playlist.model)<25:
                            nb = 25-len(self.media_organizer.player.playlist.model)
                            if nb > 5 : nb=5
                        if nb > 0:
                            if nb > len(songs): nb = len(songs)
                            for i in range(0,nb):
                                self.blacklist_songs.append(songs[i])
                                self.media_organizer.player.playlist.add_song(songs[i])

                            while len(self.blacklist_songs)>100:
                                self.blacklist_songs.pop(0)

    def make_btn_artist(self,name,url,match,image_url):
        #print name,url,match
        btn = gtk.Button()
        btn.set_relief(gtk.RELIEF_NONE)
        progress = gtk.ProgressBar()
        progress.set_ellipsize(pango.ELLIPSIZE_END)
        frac = float(match)/float(100)
        #print frac
        progress.set_fraction(frac)
        progress.set_text(_("Score")+" : "+match)
        #progress.set_text_alignment( 0.1, 0.5 )

        l = gtk.Label()
        l.set_markup("<b>"+utils.xmlescape(name)+"</b>")
        l.set_alignment(0,0.5)
        l.set_ellipsize(pango.ELLIPSIZE_END)
        pbox = gtk.VBox(False,0)
        pbox.pack_start(l)
        pbox.pack_start(progress,False,False)



        image = gtk.Image()
        sock = urllib.urlopen(image_url)
        loader = gtk.gdk.PixbufLoader()
        loader.set_size(40, 40)
        loader.connect("closed", lambda loader,image : gobject.idle_add(image.set_from_pixbuf,loader.get_pixbuf()) ,image)
        loader.write(sock.read())
        sock.close()
        loader.close()


        box = gtk.HBox(False,6)
        box.pack_start(image,False,False)
        box.pack_start(pbox,True,True)
        btn.add(box)
        btn.connect("clicked",utils.url_hook,url)
        return btn


